-- ver 1.11
-- by Changsoo Eun
-- www.changsooeun.com
macroScript CustomDefaultParamManager
	category:"csTools"
	toolTip:"CustomDefaultParamManager"
(
	global setUserDefinedDefaultRol
	fn getAllClasses prgbar:undefined = (
		local result = dictionary #string
		undo off (
			local si = 0
			local totals = superclasses.count
			local numstrs = #("0", "1", "2", "3", "4", "5", "6", "7", "8", "9")
			for sc in superclasses do (
				for c in sc.classes do (					
					if (isProperty c #localizedname) then (
						if c.localizedname != undefined and c.localizedname != "" and (classof c) != AttributeDef then ( 					
							if (finditem numstrs (c as string)) == 0 and (tolower (substring (c as string) 1 4)) != "osl_" and (tolower (substring (c as string) 1 6)) != "growfx" then (
								local isCompatibleClass						
								try(DefaultParamInterface.IsClassCompatible c &isCompatibleClass)catch()
								if isCompatibleClass == #success then (
									result[c.localizedname] = c 
								)
							)
						)
					)
				)
				if prgbar != undefined then (
					si += 1
					prgbatval = ((si/(totals as float)*100.0) as integer)
					prgbar.value = prgbatval
				)
			)
		)
		result
	)	
	try(destroyDialog setUserDefinedDefaultRol)catch()
	local rolWidth = 420
	local buttonSize = 48
	rollout setUserDefinedDefaultRol "Custom Default Param Manager 1.11" (
		listbox classLbx "Class" height:18 across:2
		listbox propnameLbx "Property" height:18
		edittext classSearchEtxt "" offset:[-4, -4] width:((rolWidth - 18)/2) across:2
		edittext propnameSearchEtxt "" offset:[-4, -4] width:((rolWidth - 18)/2) 
		progressbar startPrgbar "" width:((rolWidth - 24)/1) height:2 color:green align:#center offset:[-1,0]
		Group "Paramater" (
			label superclassLbl "" offset:[4, 0] align:#left
			checkbox valChkbx "" visible:false align:#right offset:[0, -18] -- pos:(superclassLbl.pos + [(setUserDefinedDefaultRol.width*0.75), 0])
			spinner valSpnr "" width:(setUserDefinedDefaultRol.width*0.25) align:#right offset:[0, -18] visible:false -- pos:valChkbx.pos 			
			colorpicker colorPckr "" width:100 visible:false align:#right offset:[0, -18]
		) 
		group "Set Default Value " (
			checkbutton persistChkbtn "Persistent" width:((rolWidth - 24)/2) offset:[0, -3] checked:true across:2
			button setBtn "Set" width:((rolWidth - 24)/2) offset:[0, -3]			
		)
		Group "Clear Default Value"(
			button clearSelParamBtn "Clear Selected Param" width:((rolWidth - 24)/2) offset:[0,0] across:2
			button restoreFactoryDefaultBtn "Restore to Factory Default Value" width:((rolWidth - 24)/2) offset:[0,0] 
			button clearAllParamBtn "Clear All Default Param of Class" offset:[-2, -4] width:(rolWidth - 24)
		)		

		local allClassDic
		local selectedClass
		local allclasses = #()
		local allPropnameList = #()
		local supportedValClass = #(float, integer, booleanClass, color)
		on setUserDefinedDefaultRol open do (
			local maxver = (maxversion())
			if maxver.count > 3 and (maxver[8] > 2021 or (maxver[8] == 2021 and maxver[5] > 0)) then (
				allClassDic= (getAllClasses prgbar:startPrgbar)
				allclasses = (allClassDic.Keys) 
				fn stringCmpFN s1 s2 = (stricmp s1 s2)
				qsort allclasses stringCmpFN
				classLbx.items = (sort allclasses)
				classLbx.selection = 0
			)
			else(
				messagebox "3dsMax 2021.1 + is requred"
				try(destroyDialog setUserDefinedDefaultRol)catch()
			)
		)
		fn updatePropnameList selClassStr = (
			local propnamarr = #()
			if classLbx.selected != undefined then (
				selClass = createInstance allClassDic[selClassStr] forceCreate:on
-- 				format "%\t%\n" selClassStr allClassDic[selClassStr] 
				if selClass != undefined then (
					propnamarr = #()
					for pn in (getPropnames selClass) do (
						if (isProperty selClass pn) and (findItem supportedValClass (classof (getProperty selClass pn))) > 0 then (
							append propnamarr pn
						)
					) 
					propnameLbx.items = propnamarr
				)
				else(
					propnameLbx.items = #()
				)
				propnameLbx.selection = 0
			)
			#(selClass, propnamarr)
		)
		on classSearchEtxt changed arg do (		
			classLbx.items = (for itm in allclasses where (matchpattern itm pattern:("*" + arg + "*")) collect itm)
			if classLbx.items.count > 0 then ( 
				classLbx.selection = 1	
				local updatePn = (updatePropnameList classLbx.selected)
				selectedClass = updatePn[1]
				allPropnameList = updatePn[2]
			)
		)
		fn updateValUI = (	
			if selectedClass != undefined and propnameLbx.selected != undefined then (
				format "% %\n" selectedClass propnameLbx.selected
				superclassLbl.text = ((selectedClass as string) + "." + propnameLbx.selected)
-- 				showProperties selectedClass
				local val = (getProperty selectedClass propnameLbx.selected)
-- 				format "% %\n" selectedClass val
				local suportedtype = false
				if (classof val) == float then (
					valChkbx.visible = false 
					valSpnr.visible = true 
					colorPckr.visible = false
					valSpnr.value = val
					suportedtype = true
				)
				if (classof val) == integer then (
					valChkbx.visible = false 
					valSpnr.visible = true 
					colorPckr.visible = false
					valSpnr.value = val
					suportedtype = true
				)				
				if (classof val) == booleanClass then (
					valChkbx.visible = true 
					valSpnr.visible= false 
					colorPckr.visible = false 
					valChkbx.checked = val
					suportedtype = true
				)		
				if (classof val) == Color then (
					valChkbx.visible = false 
					valSpnr.visible= false
					colorPckr.visible = true 
					colorPckr.color = val
					suportedtype = true
				)				
				if suportedtype == false then (
					superclassLbl.text = ""
					valChkbx.visible = valSpnr.visible = false					
				)
			)
			else(
				superclassLbl.text = ""
				valChkbx.visible = valSpnr.visible = false
			)
		)			
		on classLbx selected arg do (	
			local updatePn = (updatePropnameList classLbx.selected)
			selectedClass = updatePn[1]
			allPropnameList = updatePn[2]			
			updateValUI()
-- 			superclassLbl.text = ""
-- 			valChkbx.visible = valSpnr.visible = false			
		)
		on propnameSearchEtxt changed arg do (		
			propnameLbx.items = (for itm in allPropnameList where (matchpattern itm pattern:("*" + arg + "*")) collect itm)
			if classLbx.items.count > 0 then ( 
				propnameLbx.selection = 1	
				updateValUI()
			)
		)		
		on propnameLbx selected arg do (
			updateValUI()
		)
		on setBtn pressed do (
			if allclasses != undefined and propnameLbx.selected != undefined then (
				local val
				if valChkbx.visible == true then (val = valChkbx.checked)
				if valSpnr.visible == true then (val = valSpnr.value)					
				if colorPckr.visible == true then (val = colorPckr.color)	
				if val != undefined then (
					local selc = allClassDic[classLbx.selected]
					local result = (DefaultParamInterface.SetDefaultParamValue selc propnameLbx.selected val persistent:persistChkbtn.checked)
					format "Set default for %.% to %\n" selc propnameLbx.selected val
					messagebox ("Set default for " + superclassLbl.text + " : " + (result as string))
				)
			)
		)		
		on clearSelParamBtn pressed do (
			local selc = allClassDic[classLbx.selected]
			result = DefaultParamInterface.ClearDefaultParamValue selc propnameLbx.selected
			messagebox ("Clear Default ParamValue for " + superclassLbl.text + " : " + (result as string))
		)
		on restoreFactoryDefaultBtn pressed do (
			local selc = allClassDic[classLbx.selected]
			result = DefaultParamInterface.RestoreFactoryDefaultValue selc propnameLbx.selected
			messagebox ("Restore Factory Default Value for " + superclassLbl.text + " : " + (result as string))
		)		
		
		
		on clearAllParamBtn pressed do (
			local selc = allClassDic[classLbx.selected]
			result = DefaultParamInterface.ClearAllDefaultParamValues selc	
			messagebox ("Clear all default for " + classLbx.selected + " : " + (result as string))			
		)
	)
	createDialog setUserDefinedDefaultRol width:rolWidth
)

-- showInterface DefaultParamInterface
--   Interface: DefaultParamInterface
--    Properties:
--    Methods:
--     <boolean>IsClassCompatible <class>class <&enum>result
--        result enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden}
--        result is Out parameter
--     <value>GetDefaultParamValue <class>class <string>parameterName <&enum>result
--        result enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden}
--        result is Out parameter
--     <enum>SetDefaultParamValue <class>class <string>parameterName <value>defaultValue persistent:<boolean>
--        SetDefaultParamValue enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden
--        persistent default value: false
--     <enum>ClearDefaultParamValue <class>class <string>parameterName
--        ClearDefaultParamValue enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden
--     <enum>ClearAllDefaultParamValues <class>class
--        ClearAllDefaultParamValues enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden
--     <enum>IsDefaultParamValueOverridden <class>class <string>parameterName
--        IsDefaultParamValueOverridden enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden
--     <enum>RestoreFactoryDefaultValue <class>class <string>parameterName
--        RestoreFactoryDefaultValue enums: {#success|#incompatibleClass|#parameterNotFound|#invalidParameterValue|#classNotFound|#iniFileWriteFailure|#paramNotOverridden|#paramOverridden
--    Actions:
-- OK