-- csArrayMaker v1.1
-- by Changsoo Eun
-- www.cganimator.com
macroScript csArrayMaker
	category:"csTools"
	buttontext:"csArrayMaker"
	toolTip:"csArrayMaker"
(

	global csArrayMaker_rol
	
	try(DestroyDialog ::csArrayMaker_rol)catch()

	local defaultSize = [240, 200]
	local buttonwidth = (defaultSize.x - 24)	
	local arrWireColor = (color 2 95 154)
	rollout csArrayMaker_rol "csArrayMaker v1.0" (
		group "Primitives" (
			button circleBtn "Circle" width:buttonwidth
			button triangleBtn "Triangle" width:buttonwidth
			button diamondBtn "Diamond" width:buttonwidth
			button hexagonBtn "Hexagon" width:buttonwidth
		)
		group "Tiles" (
			button herringboneBtn "Herringbone" width:buttonwidth
			button chevronBtn "Chevron" width:buttonwidth
			button woodstripBtn "Wood Strip" width:buttonwidth
			button baskerweaveBtn "Basker Weave" width:buttonwidth
		)
		group "Options" ( 
			checkbox chamferdChkbx "Chamfered" checked:true across:2 align:#left
			spinner sizeSpnr "Size" fieldwidth:50 range:[0.11, 9999, 10.0] offset:[2, 0]
			spinner createIDUV "Create Clone ID UV (0 to skip)" align:#right type:#integer fieldwidth:50 range:[0, 99, 2] offset:[2, 0]
		)
		group "Material" (
			button bitmapPrjMtlBtn "Bitmap Projection" width:buttonwidth
			button randomColorMtlBtn "Random Color Mtl" width:buttonwidth
			button randomSwitcherMtlBtn "Random Color Switcher Mtl" width:buttonwidth		 		
			button randomBitmapMtlBtn "Random UV Offset Bitmap Mtl" width:buttonwidth			
			button randomAdvWoodMtlBtn "Random Advanced Wood Mtl" width:buttonwidth	
		)

		on csArrayMaker_rol open do (
			local maxver = (maxversion())
			if not ( maxver.count > 7 and ( maxver[8] > 2023 or (maxver[8] == 2023 and maxver[5] > 1))) then (
				destroydialog ::csArrayMaker_rol
				messagebox "csArrayMaker is based on Array modifier of 3dsMax 2023.2"
			)
		)
		
		fn getSourceCyl sides = (
			local o
			local radius = (sizeSpnr.value/2.0)
			local height = (sizeSpnr.value/5.0)
			if chamferdChkbx.checked then (
				o = (ChamferCyl radius:radius height:height heightsegs:1 sides:sides wireColor:arrWireColor Smooth_On:false)
			)
			else (
				o = (Cylinder radius:radius height:height heightsegs:1 sides:sides wireColor:arrWireColor  Smooth_On:false)
			)
			o
		)

		fn getSourceBox widthMul = (
			local o
			local width = sizeSpnr.value*widthMul
			local height = (sizeSpnr.value/5.0)
			if chamferdChkbx.checked then (
				o = (ChamferBox length:sizeSpnr.value width:width height:height filletsegs:1 smooth:false wireColor:arrWireColor )
			)
			else (
				o = (Box length:sizeSpnr.value width:width height:height filletsegs:1 smooth:false wireColor:arrWireColor )
			)
			o
		)
		
		fn setFillet o = (
			if chamferdChkbx.checked then ( o.baseObject.fillet = (o.baseObject.height/10.0)	 )
		)
		fn setUV2 arrmod id:2 method:1 additive:false = (
			if id > 0 then (
				arrmod.uvNormalize = (method == 1)
				arrmod.uvMethod = method
				arrmod.uvChannel = id
				arrmod.uvAdditive = additive
				if additive then ( arrmod.uvSource = id )
			)
		)
		
		
		on circleBtn pressed do (
			local o = (getSourceCyl 32)
			o.name = "csArrayMaker_Circle"
			local thearraymod = (Arraymodifier type:0 countx:20 county:20 countz:0 offsetx:0 offsety:0 offsetz:0 center:true \
					spacingx:0.0 spacingy:0.0 spacingz:0.0  )
			thearraymod.type = 0
			thearraymod.gridPositionMethod = 2
			addmodifier o thearraymod				
			paramWire.connect2Way o.baseObject[#radius] o.modifiers[#array][#spacingX] "spacingX*0.5" "radius*2" 
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#spacingY] "radius*2*(sin 60)"
			paramWire.connect2Way o.baseObject[#radius] o.modifiers[#array][#posx] "posx" "radius" 
			
			o.baseObject.Cap_Segments = 1
			setFillet o
			setUV2 thearraymod id:createIDUV.value
		)
		on triangleBtn pressed do (
			local o = (getSourceCyl 3)
			o.name = "csArrayMaker_Triangle"
			local xformmod = (xform())
			addmodifier o xformmod
			xformmod.gizmo.transform = (matrix3 [0,1,0] [-1,0,0] [0,0,1] [0,0,0])
			paramWire.connect o.baseObject[#radius] o.modifiers[#xform][#gizmo][#position][#Y_Position] "radius*((sin 30)*0.5 - 0.5)"

			local thearraymod = (Arraymodifier type:0 countx:40 county:20 countz:0 offsetx:0.5 offsety:1.0 offsetz:0 center:true \
				spacingx:0.0 spacingy:0.0 spacingz:0.0  )
			thearraymod.gridLocalRotationMethod = 4 
			thearraymod.localRotationZ = 180.0
			addmodifier o thearraymod
			
			o.baseObject.Cap_Segments = 1
			setFillet o
			setUV2 thearraymod id:createIDUV.value
		)	
		on diamondBtn pressed do (
			local o =  (getSourceCyl 4)
			o.name = "csArrayMaker_Diamond"
			local thearraymod = (Arraymodifier type:0 countx:20 county:40 countz:0 offsetx:0 offsety:0 offsetz:0 center:true \
					spacingx:0.0 spacingy:0.0 spacingz:0.0  )
			thearraymod.type = 0
			thearraymod.gridPositionMethod = 2
			addmodifier o thearraymod				
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#spacingX] "radius*2" 
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#spacingY] "radius"
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#posx] "radius" 
			
			o.baseObject.Cap_Segments = 1
			setFillet o
			setUV2 thearraymod id:createIDUV.value
		)		
		on hexagonBtn pressed do (
			local o =  (getSourceCyl 6)
			o.name = "csArrayMaker_Hexagon"
			local thearraymod = (Arraymodifier type:0 countx:20 county:20 countz:0 offsetx:0 offsety:0 offsetz:0 center:true \
				spacingx:0.0 spacingy:0.0 spacingz:0.0 wireColor:green)
			thearraymod.gridPositionMethod = 2
			thearraymod.localRotationZ = 30
			addmodifier o thearraymod				
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#spacingX] "radius*2*(cos 30)" 
			paramWire.connect o.baseObject[#radius] o.modifiers[#array][#spacingY] "radius*(2 - (sin 30))"
			paramWire.connect2Way o.baseObject[#radius] o.modifiers[#array][#posx] "posx" "radius*(cos 30)" 
			o.baseObject.Cap_Segments = 1
			setFillet o
			setUV2 thearraymod id:createIDUV.value
		)


		on herringboneBtn pressed do (
			local o = (getSourceBox 4)
-- 			(ChamferBox length:1.0 width:4.0 height:0.25 fillet:0.025 filletsegs:1 smooth:false wireColor:arrWireColor )
			o.name = "csArrayMaker_Herringbone"
			addmodifier o (uvwmap maptype:4 length:1 width:1 height:1)
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#length] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#width] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#height] "width*2" 	 
			
			local the1starraymod = (Arraymodifier type:0 countx:2 county:0 countz:0 offsetx:1.0 offsety:0 offsetz:0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			the1starraymod.gridLocalRotationMethod = 2
			the1starraymod.localRotationZ = 90.0
			the1starraymod.gridPositionMethod = 1
			the1starraymod.worldRotationZ = 45

			local floatExp_offset = float_expression()
			local wController = bezier_float()
			o.baseObject.width.controller = wController	
			floatExp_offset.AddScalarTarget "w" wController
			local lController = bezier_float()
			o.baseObject.length.controller = lController	
			floatExp_offset.AddScalarTarget "l" lController				
			floatExp_offset.setExpression "(w+l)*(-0.5)"
			the1starraymod.posx.controller = floatExp_offset
			the1starraymod.posy.controller = floatExp_offset
			addmodifier o the1starraymod				
			setFillet o
			setUV2 the1starraymod method:2 id:createIDUV.value additive:false
				 
			local the2ndarraymod = (Arraymodifier type:0 countx:10 county:40 countz:0 offsetx:0 offsety:0 offsetz:0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			paramWire.connect o.baseObject[#length] the2ndarraymod[#spacingY] "length*sqrt(2)"
			paramWire.connect o.baseObject[#width] the2ndarraymod[#spacingX] "width*(cos 45)*2"
			addmodifier o the2ndarraymod	
			setUV2 the2ndarraymod method:1 id:createIDUV.value additive:true			 
		)
		on chevronBtn pressed do (
			local o = (getSourceBox 2.5)
-- 			(ChamferBox length:2.0 width:5.0 height:0.25 fillet:0.025 filletsegs:1 smooth:false wireColor:arrWireColor )
			o.name = "csArrayMaker_Chevron"
			addmodifier o (skew amount:4.0 direction:90.0 axis:1)
			
			local uvwmapmod = (uvwmap maptype:4 length:1 width:1 height:1)
			addmodifier o uvwmapmod
			redrawViews()
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#length] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#width] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#height] "width*2" 	 

			local floatExp_rot = float_expression()
			local wController = bezier_float()
			o.baseObject.width.controller = wController	
			floatExp_rot.AddScalarTarget "w" wController
			local amtController = bezier_float()
			o.modifiers[skew].amount.controller = amtController	
			floatExp_rot.AddScalarTarget "amt" amtController				
			floatExp_rot.setExpression "(atan (amt/w))*(-0.0174533)" 
			o.modifiers[uvwmap].gizmo.rotation.z_rotation.controller = floatExp_rot
			addmodifier o (symmetry PlanarX:true PlanarY:false PlanarZ:false slice:false) 
			paramWire.connect o.baseObject[#width] o.modifiers[#symmetry][#mirror][#position][#X_Position] "width*0.5"

			local thearraymod = (Arraymodifier type:0 countx:10 county:40 countz:0 offsetx:0 offsety:0 offsetz:0 center:true \
					spacingx:0.0 spacingy:0.0 spacingz:0.0  )
			thearraymod.type = 0
			thearraymod.gridPositionMethod = 2
			addmodifier o thearraymod				
			paramWire.connect o.baseObject[#width] o.modifiers[#array][#spacingX] "width*2" 
			paramWire.connect o.baseObject[#length] o.modifiers[#array][#spacingY] "length"
			setFillet o
			setUV2 thearraymod id:createIDUV.value
			
		)
		on woodstripBtn pressed do (
			local o =  (getSourceBox 2)
-- 			(ChamferBox length:1.0 width:2.0 height:0.25 fillet:0.025 filletsegs:1 smooth:false wireColor:arrWireColor )
			o.name = "csArrayMaker_Woodstrip"
			local the1starraymod = (Arraymodifier type:0 countx:25 county:0 countz:0 offsetx:0.0 offsety:0.0 offsetz:1.0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			the1starraymod.randomizationScaleX = 70
			addmodifier o the1starraymod
			setUV2 the1starraymod method:2 id:createIDUV.value additive:false
				 
			addmodifier o (uvwmap maptype:4 length:1 width:1 height:1)
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#length] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#width] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#height] "width*2" 	 


			local the2ndarraymod = (Arraymodifier type:0 countx:10 county:10 countz:0 offsetx:1.0 offsety:1.00 offsetz:0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			the2ndarraymod.distributionMethod = 2
			the2ndarraymod.width = (sizeSpnr.value*50.0)
			the2ndarraymod.length = (sizeSpnr.value*50.0)
			the2ndarraymod.byElement = on
			the2ndarraymodelementX = on
			the2ndarraymod.packElements = on
			the2ndarraymod.elementSeed = (timestamp())				 
			addmodifier o the2ndarraymod	
			setFillet o
			setUV2 the2ndarraymod method:1 id:createIDUV.value additive:true	
		)
		on baskerweaveBtn pressed do (
			local o =  (getSourceBox 2)
-- 			(ChamferBox length:1.0 width:2.0 height:0.25 fillet:0.025 filletsegs:1 smooth:false wireColor:arrWireColor )
			paramWire.connect o.baseObject[#width] o.baseObject[#length] "width*0.5" 	 
			o.name = "csArrayMaker_BaskerWeave"
			addmodifier o (uvwmap maptype:4 length:1 width:1 height:1)
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#length] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#width] "width*2" 	 
			paramWire.connect o.baseObject[#width] o.modifiers[#uvwmap][#height] "width*2" 	 			
			
			local the1starraymod = (Arraymodifier type:0 countx:1 county:2 countz:0 offsetx:1.0 offsety:1.0 offsetz:1.0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			addmodifier o the1starraymod
			setUV2 the1starraymod method:2 id:createIDUV.value additive:false
				 
			local the2ndarraymod = (Arraymodifier type:0 countx:20 county:20 countz:0 offsetx:0.0 offsety:0.0 offsetz:0 \
				 spacingx:0.0 spacingy:0.0 spacingz:0.0 center:true)
			the2ndarraymod.gridLocalRotationMethod = 2
			the2ndarraymod.localRotationZ = 90.0				
			addmodifier o the2ndarraymod	
			paramWire.connect o.baseObject[#width] the2ndarraymod[#spacingX] "width" 
			paramWire.connect o.baseObject[#width] the2ndarraymod[#spacingY] "width"				
			setFillet o
			setUV2 the2ndarraymod method:1 id:createIDUV.value additive:true	
		)		


		on bitmapPrjMtlBtn pressed do (
			local mtl = (PhysicalMaterial name:"TileMaker_BitmapProjection")
			local btmap = (Bitmaptexture filename:((getdir #maxroot) + "\\maps\\uvwunwrap\\uv_checker.png"))
			btmap.coords.mapChannel = createIDUV.value
			btmap.coords.U_Tile = false
			btmap.coords.V_Tile = false
			btmap.coords.U_Tiling = 0.99
			btmap.coords.V_Tiling = 0.99
			mtl.base_color_map = btmap
			selection.material = mtl
		)		
		on randomColorMtlBtn pressed do (
			(NitrousGraphicsManager.GetActiveViewportSetting()).ShowMaterialOption = #Realistic
			(NitrousGraphicsManager.GetActiveViewportSetting()).OverrideMaterialOption  = #RenderingSetting
			local mtl = (PhysicalMaterial name:"TileMaker_randomColor")
			local uvmap = (osl_GetUVW UVSet:createIDUV.value)
			local rndIdx = (osl_RandomIndex2 InputColor_map:uvmap Min:0 Max:256 seed:(random 1 30000))
			local rndCol = (osl_IdxRndCol idx_map:rndIdx seed:(random 1 30000))
			mtl.base_color_map = rndCol
			selection.material = mtl
		)
		on randomSwitcherMtlBtn pressed do (
			(NitrousGraphicsManager.GetActiveViewportSetting()).ShowMaterialOption = #Realistic
			(NitrousGraphicsManager.GetActiveViewportSetting()).OverrideMaterialOption  = #RenderingSetting
			local mtl = (PhysicalMaterial name:"TileMaker_randomSwitcher")
			local uvmap = (osl_GetUVW UVSet:createIDUV.value)
			local rndIdx = (osl_RandomIndex2 InputColor_map:uvmap Min:0 Max:5 seed:(random 1 30000))
			local rndCol = (osl_Float1ofN Index_map:rndIdx)
			rndCol.I0 = (color 10 95 161)	
			rndCol.I1 = (color 83 146 144)
			rndCol.I2 = (color 207 227 227)
			rndCol.I3 = (color 3 100 102)
			rndCol.I4 = (color 1 36 64)
		
			mtl.base_color_map = rndCol
			selection.material = mtl
		)		
		on randomBitmapMtlBtn pressed do (
			(NitrousGraphicsManager.GetActiveViewportSetting()).ShowMaterialOption = #Realistic
			(NitrousGraphicsManager.GetActiveViewportSetting()).OverrideMaterialOption  = #RenderingSetting
			local mtl = (PhysicalMaterial name:"TileMaker_randomBitmap")
			local uvmap = (osl_GetUVW UVSet:createIDUV.value)
			local rndIdx = (osl_RandomIndex2 InputColor_map:uvmap Min:0 Max:256 seed:(random 1 30000))
			local rndBitmap = (osl_RandomTilingBitmap Seed_map:rndIdx)
			rndBitmap.filename = (getdir #maxroot) + "\\maps\\uvwunwrap\\uv_checker.png"
			rndBitmap.RandomizePos = 0
			rndBitmap.RotMin = -3
			rndBitmap.RotMax = 3			
			rndBitmap.ScaleMin =1
			rndBitmap.ScaleMax = 1.5
			rndBitmap.UOffset = 0.5
			rndBitmap.VOffset = 0.5
			rndBitmap.HSVMin = [0.0, 0.8, 0.9]
			rndBitmap.HSVMax = [0.0, 1.3, 1.1]
			rndBitmap.Scale = 1.0
			local outSel = MultiOutputChannelTexmapToTexmap sourceMap:rndBitmap outputChannelIndex:1
			mtl.base_color_map = outSel
			selection.material = mtl			
		)
		on randomAdvWoodMtlBtn pressed do (
			local sel = selection as array
			for o in sel do (
				local uvwmapmod = o.modifiers[uvwmap]
				if uvwmapmod == undefined then (
					uvwmapmod = (uvwmap())
					addmodifier o uvwmapmod before:o.modifiers.count
				)
				uvwmapmod.maptype = 6
			)
			
			(NitrousGraphicsManager.GetActiveViewportSetting()).ShowMaterialOption = #Realistic
			(NitrousGraphicsManager.GetActiveViewportSetting()).OverrideMaterialOption  = #RenderingSetting
			local mtl = (PhysicalMaterial name:"TileMaker_randomBitmap")
			local uvmap = (osl_GetUVW UVSet:createIDUV.value)
			local rndIdx = (osl_RandomIndex2 InputColor_map:uvmap Min:0 Max:256 seed:(random 1 30000))			
			local rndFltOffset = (osl_IdxRndFlt idx_map:rndIdx min:-100 max:100)
			local rndFltRot = (osl_IdxRndFlt idx_map:rndIdx min:-3 max:3)
			local rndVec = (osl_VectorJuggler Xi_map:rndFltOffset Yi_map:rndFltOffset Zi_map:rndFltOffset)
			local outSel_rndVec = MultiOutputChannelTexmapToTexmap sourceMap:rndVec outputChannelIndex:1
			local orguvmap = (osl_GetUVW UVSet:1)
			local uvTM = (osl_UVWTransform Input_map:orguvmap Offset_map:outSel_rndVec Rotate_map:rndFltRot)
			local avdwood = (osl_prism_wood scale:0.5 axis:0 UVW_map:uvTM)			
			local outSel_avdwood = MultiOutputChannelTexmapToTexmap sourceMap:avdwood  outputChannelIndex:1
				
			mtl.base_color_map = outSel_avdwood
			selection.material = mtl				
		)
	)

	createDIalog csArrayMaker_rol width:defaultSize.x

)
