global csMakePreviewRol
global csMakePreviewSettingsRol
macroScript csMakePreview
	category:"csTools"
	toolTip:"csMakePreview"
(
	try(DestroyDialog csMakePreviewRol)catch()
	try(DestroyDialog ::csMakePreviewSettingsRol)catch() 

	rollout csMakePreviewSettingsRol "csMakePreview - Settings" (
		group "Player" (
			Radiobuttons playerRbtn "" labels:csMakePreviewRol.playerTypes align:#center
			label playerPath_lbl ""
			button playerpathBtn "Browse Player Path..."  align:#left width:(csMakePreviewSettingsRol.width - 24)
		)
		group "FFmpeg" (
			label ffmpegPath_lbl ""
			button ffmpegPathBtn "Browse FFmpeg Path..."  align:#left width:(csMakePreviewSettingsRol.width - 24)
		)
		button openSettingFIlePathBtn "Open Settings File Path" width:(csMakePreviewSettingsRol.width - 24)
		
		fn updateLbl = (
			if (doesFileExist playerpathBtn.tooltip) then (
				playerPath_lbl.text = playerpathBtn.tooltip
			)
			else(
				playerPath_lbl.text = "[N/A]"
				playerpathBtn.tooltip = ""
			)
			if (doesFileExist ffmpegPathBtn.tooltip) then (
				ffmpegPath_lbl.text = ffmpegPathBtn.tooltip
			)
			else(
				ffmpegPath_lbl.text = "[N/A]"
				ffmpegPathBtn.tooltip = ""
			)				
		)
		on csMakePreviewSettingsRol open do (
			playerRbtn.state = (finditem (for itm in csMakePreviewRol.playerTypes collect (itm as name)) (csMakePreviewRol.playerType as name))
			playerpathBtn.tooltip = csMakePreviewRol.playerpath
			ffmpegPathBtn.tooltip = csMakePreviewRol.ffmpegPath 
			updateLbl()
		)
		
		on playerRbtn changed arg do (
			local selType = csMakePreviewRol.playerTypes[arg]
			csMakePreviewRol.playerType = (selType as name)
			setIniSetting (csMakePreviewRol.getSettingFile()) "Player" "Type" csMakePreviewRol.playerTypes[arg]
			playerpathBtn.tooltip = ""
			setIniSetting (csMakePreviewRol.getSettingFile()) "Player" "Path" ""
			updateLbl()
		)
		on playerpathBtn pressed do (
			local selType = csMakePreviewRol.playerTypes[playerRbtn.state]
			local defaultPath = ""
			if (selType as name) == #chaosplayer then (
				defaultPath = (csMakePreviewRol.getChaosPlayerPath())
			)
			local playerpath = (getOpenFileName caption:("Pick " + (selType as string) + "exe path") filename:defaultPath)
			if playerpath != undefined then (
				format "> setting player path - %\n" playerpath
				setIniSetting (csMakePreviewRol.getSettingFile()) "Player" "Path" playerpath
				playerpathBtn.tooltip = playerpath
				csMakePreviewRol.playerpath = playerpath
			)
			updateLbl()
		)
		on ffmpegPathBtn pressed do (
			local defaultPath = ""
			local ffmpegPath = (getOpenFileName caption:("Pick ffmprg.exe path") filename:defaultPath)
			if ffmpegPath != undefined then (
				format "> setting FFmpeg path - %\n" ffmpegPath
				setIniSetting (csMakePreviewRol.getSettingFile()) "FFmpeg" "Path" ffmpegPath
				ffmpegPathBtn.tooltip = ffmpegPath
				csMakePreviewRol.ffmpegPath = ffmpegPath
			)
			updateLbl()
		)			
		on openSettingFIlePathBtn pressed do (
			shellLaunch (getFilenamePath (csMakePreviewRol.getSettingFile())) ""
		)
	)	

	dotNet.loadAssembly "System.Web"
	local openIconB = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAyUlEQVR4nO3UPUoDURiF4UcklaWtP7Wpswa7kD6LEI1gOkm6aVxEuhTZQ5rU2YI7MKQKiDgSuIIMc+fPgTTzwmlucV7uVxw6anCDB0z/5AX3WuAWO6SRrHDxH8FTKLrLvPfwjC9scdVUMAuCGEN8F/zwN3u84ayO4BLrIFggKcgy9Ixigmkmc7zjgHGFS5yHnteYIJtPbDBQnTT05QraIO0EZXQnanai2BbVpR96HvOm+qPC1qQVcuy5zrMfJZOSrUlKMomVd5yOH6BJaPy6AUwDAAAAAElFTkSuQmCC"
	local openIconW ="iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAyUlEQVR4nO3UMWoCURhFYYOkskyrptbaNaQTexcRjIHYiXY2WYSdhXuwSZ0tZAcjVoEQ8oWBR5Dh6RuNYDMHbjMD98B98NdqFWVBG4+Y7OUFD5cov8fWYdZo/EfwFIo6he+3eMY33tE8VzDL24/87+NHmh1ecVNagDtsgmCJxZGsgmgQFRQeOM8cH/jEsMQS9dAzPSQo8oU39NJD/3XlzEpPdCqVIEk10dkTRW/RqaAbekaxU525DBlaMXsuGSduzSKRcbS84qr8AkLmNUyr7EPxAAAAAElFTkSuQmCC"
	local playIconW = "iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAYAAADE6YVjAAAACXBIWXMAAAsTAAALEwEAmpwYAAABvklEQVR4nO3UPWtVQRDG8YNoEiFIiogSoqIgxkoLra9NCqsIwUAQ0vkBUhjE1ypYWWklBhWxSWHSRJug+AHUNiqYwl4RERVffrI3c+FyPG9X7fTpzp5n57+zMztZ9s8I+zCL23iAZVzDJAb/NPgYlmzoAx7jbqw9ww+8xzls/R3ASXzEGqYwUOAZwXz4nmK0V0A65U30Ncz4JV5je9ZwQzrZQnzvwFCDfTvxBqtNIEtxRe0McBzvcLkOhlbUb6Kui5KmutYSJOlTExhW8KQKMhtdNFAAOYgr8b8UhlP4huEyyC08yq11IO2CYrgKhj3hP1YGeYh7VZCOAnY1ujDBLmATtsTadFZR9Pt1EBuBZvAK37GIA/FvW/hPlEGu43kZJIKfxnrc+x3sz/kPhf9IGWQyUh0pgMxF8K9Fwbv8Z/E2HagMMhizaL4AUhk8Cf3x6tsPuVQ4Hy9+LL7H64J3hIv4jL1ZldI0jWH3Io2KSvOvV52aYC5rIuyKtNMsatV4+3EpADcaAbo2p25ajXqsxEveHR2Wanc4ipwO8wVnegLkYBNpFkXL5pW6aKG2Bj1m1oqMEvgoNv+V4P+V5fQTp7XvT4R7LNUAAAAASUVORK5CYII="
	local playIconB = "iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAYAAADE6YVjAAAACXBIWXMAAAsTAAALEwEAmpwYAAABrUlEQVR4nO3UPWsUURTG8R/BzQuEYJGgBKNEELWKhdaxsbCKsEQQwS4fIIUSfK2ClZVWomgQGwtjozYS8QNEW19Ai/QJIqLBJCsXzsASZnbuGjt9YIq5c+b877nPPYd/SQcxi4d4gWe4jSYGd5r8CBbRwje8xqNYe4stfMVlDPwJYBrf8R5n0V8SM4r5iFvGvm4BaZf30JtZ8Ud8xojMH9LO7sf7HuzO+G8vVvAqB7IYR1RUcBpruJEBmwz/pupuUSs80AZJaz8yYc/xphNkNm5RfwnkKG7G906w89jAcBXkAZa2rRWQwtDhGtiBiD9ZBXmJxzUQbbBbcQsT7Cp60Ii1czqY/jQD0sAFfMImnuBwfBuK+DNVkDt41wHSwAy+xLkv4NC2+ImIP14FaUapoyWQS5H8V0XyQnNYjQ2VajBm0XwJpC55Ul90fdHIlboSHZ86P+lURvJC1/AT42o0EMPuQ4yKXDXjEqRjzdJYlL0So0LNEV0PwF1daiSGXStGRerk/WFo8u5YmJw2s46LdqCpmEUbAWx/VsPkWg+6qWwyKkrgE9j1t5L/l3b9BkzKb7MqrBPrAAAAAElFTkSuQmCC"
	local settingIconW = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAB8UlEQVR4nN3VW4tOYRQH8NedQxmTSZPJKEo0RsrpgjQ0N3JhSExSIkmamnsxTjc+gDCNyKkoiYhyKIOLaS6UlNdhbuaT/PRkTT127373Gy5k1a5n/9fa//Ws467V/gXBXFzCKC6j42872IxX6McD7P4Tstk4h+4MO4qzcT6OkUy3EOfR3ir5c9zCFPZhPcaxJ2w24SO2YBu+YgyTlU5wCnfj3IWneIm9mJXZJeL7eItVgV1MNapysAjfsLQy3EzQhi/orVVJSkVKU6VhJriG4Vorgo14UcC2Rh2mMYGBgv4OdjYjnRdFO4b3OYGf5Kmoa+J9Gd5hMLNJ336IDuvD/KKDNESvcQa7CgV9M0OeYZ2oF7AdOInH6Sk6uJoMSqKbLsHracIb4D14VgTT+D+MFG0o6CawvEHXTBWwXhzBdTwpOuiI7hnBp7QaMt1A5LwzI3+EocxmbbT3hRjOrkZRzxhvx+0CNhgpqceEDxXqNJoXvanEQhsv0c0pwe/hUCvk7XHLlS3d5tcN8B0ras0kcjgW5wUR+o00fA0KeiVW9+LATuNmKxFMxuJKW3I47f4YtP6wWR23PYCDUZO0rj9jSVMHmZN0854MO5GGKM6HU6SZrjvsq8mbOO1LvY11KQ3Y/9tkJQ7asn9D+iGV9/l/Jz8ADDiwxfTNwTEAAAAASUVORK5CYII="
	local settingIconB = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAB3ElEQVR4nO3UTYiOYRQG4MvPoBAxUmKhlKIGGyuSn2I3G6WUmqGQJEnYCetJsrIhNpopsyNFIcRG1FhhMQt/jY3E+Dd66/7q6Wu+b6bpW1i46+l9n/Oe5z7nvc95Dv8IDuJ4sda0knwO/mCkWD2tDLAppNWzwn3cmyjZEmzA5OyX4UYCzIvtHL6gG1NiW4ht4wlwLWRvcBnD+IBThU+l/+34PcQt/Mpa3Yx8cw5dRD++4hJmNvF/hxc4nfdKukmjOU/FAF5hWmwl8QLswzFsLOylz54kuGO0AHPxFD/QVfdtC4bquqgXbYVPOx5Fpt2NJJqNm2nJ7UXmQ3iCjiRyOD4ni7MDKXynMbAiGdYC7M1+VZ1ffxqhhuf5qzGxNoS1ljuRfZV5ibNpghoe4/p4AnSGsMpcCjoSWcqbPYg7he11ajCjGfkufMczLC7svdG8P5dsMH5lzx/CbzzA/NHI23PoZTIs0ZaCVpp/w90GF+rAWHOqJ23WkXUmRW+EakwcwU7MQh8+YVGjA1Xm79NutX7/nPFcX+T1+ZOa33CeVVM0RXeKtx9LcQE/8bEYbEdDVsm5FetwPvpPNwF0hXBl9n0ZKdV4aQmWJ8CVyPUWV7UQk1O8chZVMv2HluAv7jF/Fg/qRu8AAAAASUVORK5CYII="
	
	local saveDefaultIconW = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAA2klEQVR4nO3VMUqDQRAF4IAECSGk0S6QIueIja2XsLGwTOMBPEC6gFewtA2m8QB2dkLEwkIkTQpRwidLRvgNgR/jBoL8D6Z4sDuPebM7U6vtAnCEMR4wQjtn8h7ecYch3nCTU2CAORrBz7BAM5fAeVRwGPwCH9jPJXCAVzxHHz5TH7IkL4h0w//rqGhv00THuPpD1MsETvG4ErOw5Zu/WOJpzdnf9wWXyf8CPwmBzkY2VQI724NFmj8x6KbbEJhjgnvcVq/oB1QfrQzopxFd4GmFpqXTKr38L/AF35fpnRm5oqMAAAAASUVORK5CYII="
	local saveDefaultIconB ="iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAA00lEQVR4nO3VMWoCURAG4A8kiEhIYzrBIueIjW0ukcbCMk0O4AHSCblCyrRBGw9gZyckpLAQsbEICWJYmG0ksLC+gMj+MMXAvPmZ+d/McCLo4g1zjHCVMvkNvjDFE9Z4TUnwgC0a4fexQzMVwSAquA7/Ed+opyJoYYXP0OEndEiKTvT/JSqqlU3Uw/MRdlFEcI/FgW2iLbm/xB4ff8SW0mUY/c9xFwTtMskqAierwS72TzZg7/9BsMUEM4yrX3SIYTVoRbiNFZ0jO6HZ0bksfHkW+AViNFApOWbTuwAAAABJRU5ErkJggg=="
		
	rollout csMakePreviewRol "csMakePreview v1.0" (
		GroupBox range_grpbx "Preview Range" across:2
		GroupBox display_grpbx "Display in Preview" offset:[4, 0]
		radiobuttons range_rbtn "" labels:#("Active Time Segment", "Custom Range") columns:1 align:#left offset:[8, 4] offsets:#([0,0 ],[0, 8]) 
		spinner start_spnr "" fieldwidth:56 type:#Integer align:#left offset:[24, 4] range:[0, 99999, animationRange.start.frame] across:2
		spinner end_spnr "to" fieldwidth:56 type:#Integer pos:(start_spnr.pos + [16, 0]) range:[0, 99999, animationRange.end.frame]
		
		GroupBox framerate_grpbx "Frame Rate" offset:[0, 12]
		spinner skip_spnr "Every Nth Frame:  " range:[1, 240, 1] fieldwidth:56 type:#Integer align:#right pos:(framerate_grpbx.pos + [14, 22])
		spinner fps_spnr_ "Playback FPS:        " range:[1, 240, frameRate] fieldwidth:56 type:#Integer pos:(framerate_grpbx.pos + [14, 46])
		
		GroupBox imagesize_grpbx "Image Size" offset:[0, 12]
		spinner sizeperc_spnr "Percent of output: " range:[1, 200, 100] fieldwidth:56 type:#Integer align:#right pos:(imagesize_grpbx.pos + [14, 22])
		label res_lbl "Resolution " pos:(imagesize_grpbx.pos + [16, 46]) align:#left
		
		GroupBox overlay_grpbx "Overlay" offset:[0, 12]
		checkbox safeframe_chkbx "Safe Frames" offset:[8, 4]  across:3
		checkbox framenum_chkbx "Frame Numbers" offset:[-8, 4]
		checkbox camviewName_chkbx "Camera / View Name" offset:[-16, 4]
		checkbox snippet_chkbx "MXS Snippet"  pos:(safeframe_chkbx.pos + [0, 24]) multiLine:true
		edittext snippet_etxt "" width:(csMakePreviewRol.width - 62) align:#center height:64
		
		GroupBox visualStyle_grpbx "Visual Style" offset:[0, 12]
		checkbutton useCurrentViewport_chkbtn "Use Current Viewport Settings" width:(csMakePreviewRol.width - 48) offset:[-3, 0] checked:true
		label vpPresets_lbl "Per-View Presets: " offset:[6, 4] across:4
		dropdownlist vpPreset_dropdnblst_ "" width:110 
		label vpStyle_lbl "Preference: " offset:[0, 4] 
		dropdownlist vpStyle_dropdnblst_ ""  offset:[-21, 0]  width:108
		spinner quallity_spnr_ "Image Quality:     " fieldwidth:56 type:#Integer range:[1, 2000, 20] pos:(vpPresets_lbl.pos + [0, 24])
		checkbox edgefaces_chkbx_ "Edged Faces" offset:[8, 4]  across:2
		checkbox textures_chkbx_ "Textures" offset:[0, 4]		
		checkbox multipassfx_chkbx "Use Multi Pass Camera Effects" offset:[8, 4]  

		GroupBox output_grpbx "Output" offset:[0, 12]
		button file_btn "File..." offset:[8, 4] width:42 height:24 align:#left across:6
		dotnetcontrol play_Btn "Button" width:24 height:24 pos:(file_btn.pos + [(file_btn.width + 4), 0])
		dotnetcontrol open_Btn "Button" width:24 height:24 pos:(play_Btn.pos + [(play_Btn.width + 2), 0])		
		dotnetcontrol settings_btn "Button" width:24 height:24 pos:(open_Btn.pos + [(open_Btn.width + 2), 0])	
		dotnetcontrol saveDefault_btn "Button" width:24 height:24 pos:(settings_btn.pos + [(settings_btn.width + 2), 0])	
		checkbox playwhendone_chkbx_ "Play When Done" align:#right offset:[-2, 6]	checked:true
		edittext filename_etxt "" width:(csMakePreviewRol.width - 36 - 36) align:#left offset:[4, 0] across:2
		button tokenHelp_btn "Help" width:36  align:#right offset:[-4, -1]
		
		label presetLbl "Preset" offset:[9, 7] align:#left across:3
		dotnetcontrol presetCbox "Combobox" text:"" width:120 height:24 pos:(presetLbl.pos + [32, -2])	
		button create_btn "Create" width:200 align:#right offset:[-7, 4]

		label dummy_lbl "" offset:[0, -6]
		checkbox geometry_chkbx "Geometry" pos:(range_rbtn.pos + [(csMakePreviewRol.width/2 - 8), 0]) checked:true
		checkbox shapes_chkbx "Shapes"  pos:(geometry_chkbx.pos + [0, 20])
		checkbox lights_chkbx "Light"  pos:(shapes_chkbx.pos + [0, 20])
		checkbox cameras_chkbx "Cameras"  pos:(lights_chkbx.pos + [0, 20])
		checkbox helpers_chkbx "Helpers"  pos:(cameras_chkbx.pos + [0, 20])
		checkbox spacewarps_chkbx "Space Warps"  pos:(helpers_chkbx.pos + [0, 20])
		checkbox particle_chkbx "Particle Systems"  pos:(spacewarps_chkbx.pos + [0, 20]) checked:true
		checkbox bone_chkbx "Bone Objects"  pos:(particle_chkbx.pos + [0, 20]) checked:true
		checkbox bg_chkbx "Background"  pos:(bone_chkbx.pos + [0, 20]) checked:true
		checkbox grid_chkbx "Active Grid"  pos:(bg_chkbx.pos + [0, 20])		

		local vpPresetsLabels = #("High Quality", "Standard", "Performance", "DXMode", "User Defined")
		local viewportPresetEnums = #(#Quality,#Standard,#Performance,#DXMode,#Customize)
		local fnVpPresetEnums = #(#highquality , #standard , #performance , #dxmode , #userDefined)		
		local vpStyleLabels = #("Default Shading", "Wireframe", "Clay", "Facets",  "Bounding Box", "Hidden Line", "Flat Color", "Model Assist", "Graphite", "Color Pencil", "Ink", "Color Ink", "Acrylic", "Pastel", "Tech")
		local viewportStyleEnums = #(#Realistic,#Wireframe,#Clay,#Facets,#BoundingBox, #HiddenLine, #ConsistentColors, #modelassist, #Graphite, #ColorPencil, #Ink, #ColorInk, #Acrylic, #Pastel, #Tech)
		local fnVpStyleEnums =#(#defaultshading, #wireframe,  #clay, #facets, #boundingbox, #hiddenline , #flatcolor,  #modelassist,  #graphite, #colorpencil, #ink , #colorink ,  #acrylic ,  #pastel, #tech )

		local playerTypes = #("Default", "RamPlayer", "ChaosPlayer", "Custom")
		local playerType 
		local playerpath
		local ffmpegPath  

		fn getDateStr = (
			(((dotnetclass "system.datetime").Now).tostring("yyyy_MM_dd_HH_mm"))
		)
		fn getChaosPlayerPath = (
			local chaosPlayerPath = @"C:\Program Files\Chaos Group\Chaos Player\chaosplayer_qt5.exe"
			local chaosFolder =  @"C:\Program Files\Chaos Group\"
			if not (doesFileExist chaosPlayerPath) then (
				if (doesFileExist chaosFolder) then (
					local searchChaosFiles = (getFiles (chaosFolder + "\\chaosplayer_qt5.exe") recurse:true)
					if searchChaosFiles.count > 0 then ( 
						chaosPlayerPath = searchChaosFiles[1] 
					)
					else(
						chaosPlayerPath = ""
					)
				)
			)
			chaosPlayerPath			
		)
		fn getFinalResStr = (
			local prvWidth = ((((ceil(sizeperc_spnr.value/100.0*renderWidth*0.5)) as integer)*2) as string)
			local prvHeight = ((((ceil(sizeperc_spnr.value/100.0*renderHeight*0.5)) as integer)*2) as string)
			(prvWidth + " x " + prvHeight)
		)
		fn resolveToken token = (
			case (tolower token) of (
				default:(
					if globalvars.isGlobal token then (
						if (classof token) == MAXScriptFunction then (
							((try(execute (token + "()"))catch("")) as string)
						)
						else (
							((try(globalVars.get token)catch("")) as string)
						)
					)
					else (
						""
					)
				)
				"preview_dir":(getdir #preview)				
				"scene":(getFilenameFIle maxfilename)
				"camera/view":(
					local vptType = (viewport.getType())
					if vptType == #view_camera then (
						(viewport.getCamera()).name
					)
					else(
						case vptType of (
							default:(substitutestring (vptType as string) "view_" "")
							#view_persp_user:("perspective")
							#view_iso_user:("orthographic")
						)
					)
				)
				"mm":(formattedPrint (getLocalTime())[2] format:"02d")
				"dd":(formattedPrint (getLocalTime())[4] format:"02d")
				"yyyy":((getLocalTime())[1] as string)
			)
		)
		fn resolveFilename str = (
			local result = ""
			local splits = (dotNetClass "System.Text.RegularExpressions.RegEx").Split str "(<.*?>)"
			for split in splits do (
				if (substring split 1 1) == "<" and (substring split split.count 1) == ">" then (
					local token = (filterstring split "<>")[1]
					result = result + (resolveToken token)
				)
				else(
					result = result + split
				)
			)
			result
		)
		fn getPathInfoDic filepath = (
			local returnDic = dictionary()
			local videoFormats = #(".avi", ".mp4")	
			local pathonly = (getFilenamePath filepath)
			local nameonly = (getFilenameFile filepath)
			local typeonly = (getFilenameType filepath)
			returnDic[#nameonly] = nameonly
			returnDic[#pathonly] = pathonly
			returnDic[#typeonly] = (tolower typeonly)
			returnDic[#filepath] = filepath
			returnDic[#getFiles] = pathonly + nameonly + "*" + typeonly
			returnDic[#numbersign] = pathonly + nameonly + "####" + typeonly
			returnDic[#strformat] = pathonly + nameonly + "%04d" + typeonly
			returnDic[#ifl] =  pathonly + nameonly + ".ifl"
			returnDic[#isVideo] = ((finditem videoFormats (tolower typeonly)) > 0)
			returnDic
		)
		fn updateFilnameUI = (
			filename_etxt.tooltip = (resolveFilename filename_etxt.text)
			create_btn.enabled = (pathConfig.isLegalPath filename_etxt.tooltip)
			if not create_btn.enabled then (
				filename_etxt.tooltip = "INVALID PATH" 
				create_btn.enabled = false
			)
		)
		fn getSettingFile = (
			(getdir #usersettings) + "\\csMakePreview.ini"
		)
		fn getDataFromIni section:"Player" key:"type" default:#default = (
			local inifile = (getSettingFile())
			if (doesFileExist inifile) then (
				local val = (getINISetting inifile section key)
				if val == undefined or val == "" then (
					val = default
					setIniSetting inifile section key (default as string)
				)
			)
			else(
				val = default
				setIniSetting inifile section key (default as string)
			)
			val
		)
		
		local httputil = (dotnetclass "System.Web.HttpUtility")		
		fn getControlVal c = (
			local result = undefined
			local classc = (classof c)
			if classc == RadioControl then (result = c.state)
			if classc == SpinnerControl then (result = c.value)
			if classc == CheckButtonControl then (result = c.checked)
			if classc == CheckBoxControl then (result = c.checked)
			if classc == EditTextControl then (result = (httputil.UrlEncode c.text))
			result
		)
		fn setControlVal c val = (
			if val != "" and val != undefined then (
				local classc = (classof c)
				if classc == RadioControl then (c.state = (val as integer))
				if classc == SpinnerControl then (c.value = (val as float))
				if classc == CheckButtonControl then (c.checked = (val as booleanClass))	
				if classc == CheckBoxControl then (c.checked = (val as booleanClass))
				if classc == EditTextControl then (c.text = (httputil.UrlDecode val))
			)
		)		
		fn collectControls2save = (	
			local result = #()
			local settingIniFile = (getSettingFile())
			local class2ignore = #(LabelControl, GroupBoxControl, ButtonControl)
			for c in csMakePreviewRol.controls do (
				local classc = (classof c)
				if (finditem class2ignore classc) == 0 and (substring c.name c.name.count -1) != "_" do (
					append result c
				)
			)
			result
		)			
		fn loadPreset secname:"preset_Default"  = (
			local settingIniFile = (getSettingFile())			
			if (getINISetting settingIniFile secname).count > 0 then (
				format "> loading preset - %\n" secname
				for c in (collectControls2save()) do (			
					local val = (getINISetting settingIniFile secname c.name)
					if val != "" then (
						setControlVal c val 
					)
				)
			)
		)
		fn savePreset secname:"preset_Default" tofile:false = (	
			local result = #()
			local settingIniFile = (getSettingFile())
			if tofile then ( format "> saving preset - %\n" secname )
			for c in (collectControls2save()) do (
				if tofile then (
					setINISetting settingIniFile secname c.name ((getControlVal c) as string)
				)
				append result #(c.name, (getControlVal c))
			)
			result
		)		
		fn playChaosPlayer filenameDic fps startframe endframe  = (
			local chaosPlayerPath = (getDataFromIni section:"Player" key:"Path" default:"")
			if (doesFileExist chaosPlayerPath) then (
				local prvPath =  filenameDic[#numbersign]
				if (findItem #(".avi", ".mp4") filenameDic[#typeonly]) > 0 then (
					prvPath = filenameDic[#filepath]
				)
				local arg  = " --resize_window_to_fit"
				arg += " --back_color=dark_grey"
				arg += " --frame_base=1"
				arg += " --automatic_preload=1"
				arg += " --counter=frame"
				arg += (" --fps=" + (fps as string))
				arg += (" \"" + prvPath + "\"")
				arg += " --play_forward"
				local cmd = (filenameFromPath chaosPlayerPath) + " " + arg 
				hiddendoscommand cmd startpath:(getFilenamePath chaosPlayerPath) donotwait:true
				format "%\n" cmd
			)
		)
		fn playRamPlayer filenameDic fps startframe endframe = (
			if  filenameDic[#isVideo] then (
				ramplayer filenameDic[#filepath]  ""
			)
			else (
				local seqfiles = (getFiles filenameDic[#getFiles])
				if seqfiles.count > 0 then (					
					(dotNetClass "System.IO.File").WriteAllLines filenameDic[#ifl] seqfiles
					ramplayer filenameDic[#ifl]  ""
				)			
			)
		)
		fn playPreview ptype srcFilenameDic fps start end = ( 	 
			if ptype == #default then (
				shellLaunch  srcFilenameDic[#filepath] ""
			)
			if ptype == #RamPlayer then (
				playRamPlayer srcFilenameDic fps start end
			)
			if ptype == #ChaosPlayer then (
				playChaosPlayer srcFilenameDic fps start end
			)
			if ptype == #Custom then (
				if csPlayPreview != undefined and (classof csPlayPreview) == MAXScriptFunction then (
					csPlayPreview srcFilenameDic fps start end
				)
			)	
		)	
		
		local dnColor = dotNetClass "System.Drawing.Color"
		local dnImage = dotNetClass "System.Drawing.Image"
		local dnConvert = dotnetClass "System.Convert"	
	    fn StringToImage str = (
			local byteArr = dnConvert.FromBase64String str
			local memstream = dotnetobject "System.IO.MemoryStream" byteArr
			local DecodedImg = dnImage.fromstream memstream
			memstream.close() ; DecodedImg
		)		
		fn setDotnetButton dnButton imgstr = (
			local bgcolor = (((colorMan.getColor #button)*255.0) as color)
			dnButton.backColor = (dnColor.FromArgb bgcolor.r bgcolor.g bgcolor.b)
			local textcolor = (((colorMan.getColor #text)*255.0) as color)
			dnButton.foreColor = (dnColor.FromArgb textcolor.r textcolor.g textcolor.b)
			dnButton.FlatAppearance.MouseOverBackColor = ((dotnetclass "ControlPaint").Light dnButton.BackColor)	
			dnButton.FlatAppearance.MouseDownBackColor = ((dotnetclass "ControlPaint").LightLight dnButton.BackColor)				
			dnButton.FlatAppearance.BorderSize = 0
			dnButton.Padding.All = 0  
			dnButton.Margin.All = 0
			dnButton.Flatstyle =dnButton.Flatstyle.Flat
			dnButton.TextAlign = dnButton.TextAlign.MiddleCenter		
			dnButton.ImageAlign = dnButton.ImageAlign.MiddleCenter     
			dnButton.image = (StringToImage imgstr)
		)
		fn setDotnetCombobox dnCbox = (
			local bgcolor = (((colorMan.getColor #button)*255.0) as color)
			dnCbox.backColor = (dnColor.FromArgb bgcolor.r bgcolor.g bgcolor.b)
			local textcolor = (((colorMan.getColor #text)*255.0) as color)
			dnCbox.foreColor = (dnColor.FromArgb textcolor.r textcolor.g textcolor.b)
			dnCbox.DropDownStyle  = dnCbox.DropDownStyle.DropDown
			dnCbox.Flatstyle = dnCbox.Flatstyle.Standard
		)
		fn getPresets = (
			local presets = #()
			local inifile = (getSettingFile())
			if (doesFileExist inifile) then (			
				presets = (for sec in (getIniSetting inifile) where (tolower (substring sec 1 7)) == "preset_" collect (substring sec 8 -1))
				qsort presets stricmp
			)
			presets
		)
		fn updateVisualTypeUI = (
			edgefaces_chkbx_.enabled = (not useCurrentViewport_chkbtn.checked)
			textures_chkbx_.enabled = (not useCurrentViewport_chkbtn.checked)
			vpStyle_dropdnblst_.enabled = (not useCurrentViewport_chkbtn.checked)
			vpPreset_dropdnblst_.enabled = (not useCurrentViewport_chkbtn.checked)
		)

		on csMakePreviewRol open do (
			range_grpbx.height = 94
			overlay_grpbx.height = 140
			visualStyle_grpbx.height = 144
			output_grpbx.height = 114
			display_grpbx.width = (csMakePreviewRol.width - range_grpbx.width - 30)
			display_grpbx.height = (overlay_grpbx.pos.y - 10)
			framerate_grpbx.height = 70
			imagesize_grpbx.height = 70
			framerate_grpbx.width = range_grpbx.width
			imagesize_grpbx.width = range_grpbx.width
			vpPreset_dropdnblst_.items = vpPresetsLabels
			vpPreset_dropdnblst_.selection = 5
			vpStyle_dropdnblst_.items = vpStyleLabels
			vpStyle_dropdnblst_.selection = 1
			presetCbox.Items.Clear()
			presetCbox.Items.AddRange (getPresets())
-- 			vp_dropdnblst.items = #("Current")
			res_lbl.text = "Resolution: " + (getFinalResStr())
			filename_etxt.text = @"<preview_dir>\<scene>.mp4"
				-- @"<preview_dir>\<scene>\<scene>-<yyyy>_<mm>_<dd>_preview_.mp4"
			updateFilnameUI()
			if (colorMan.colorTheme) == #dark then (
				setDotnetButton play_Btn playIconW	
				setDotnetButton open_Btn openIconW	
				setDotnetButton settings_btn settingIconW	
				setDotnetButton saveDefault_btn saveDefaultIconW
			)
			else(
				setDotnetButton play_Btn playIconB
				setDotnetButton open_Btn openIconB	
				setDotnetButton settings_btn settingIconB
				setDotnetButton saveDefault_btn saveDefaultIconB
			)
			setDotnetCombobox presetCbox
			-- Default	
			local multipassFx = false
			local viewportCam = (viewport.GetCamera())
			if viewportCam != undefined and ((classof viewportCam) ==  Freecamera or (classof viewportCam) ==  Targetcamera) then (
				multipassFx = viewportCam.mpassEnabled
			)
			multipassfx_chkbx.checked = multipassFx

			loadPreset()
			
			updateVisualTypeUI()
			
			-- Load settings
			playerType = (getDataFromIni section:"Player" key:"Type" default:#default) as name
			playerpath = getDataFromIni section:"Player" key:"Path" default:""
			ffmpegPath = getDataFromIni section:"FFmpeg" key:"Path" default:""
		)
		
		on sizeperc_spnr changed arg do (
			res_lbl.text = "Resolution: " + (getFinalResStr())
		)
		
		on presetCbox KeyUp s e do (
			if e.KeyCode == e.KeyCode.Enter then (
				savePreset secname:("preset_" + (substituteString s.text " " "")) tofile:true
				presetCbox.Items.Clear()
				presetCbox.Items.AddRange (getPresets())					
			)
		)
		on presetCbox SelectedIndexChanged s e do (
			if s.SelectedItem != undefined then (
				loadPreset secname:("preset_" + s.SelectedItem)
			)
		)
		
		on useCurrentViewport_chkbtn changed arg do (
			updateVisualTypeUI()
		)
		
		on file_btn pressed do (
			local prvfilepath = (selectSaveBitMap())
			if prvfilepath != undefined then (
				filename_etxt.text = filename_etxt.tooltip = prvfilepath
				updateFilnameUI()
			)
		)

		on filename_etxt changed arg do (
			updateFilnameUI()
		)
		
		on tokenHelp_btn pressed do (
			local tokenHelp = #()
			append tokenHelp "<preview_dir> - preview folder" 
			append tokenHelp "<scene> - the current scene name" 
			append tokenHelp "<camera/view> - active camera/view name" 
			append tokenHelp "<mm> - month" 
			append tokenHelp "<dd> - day" 
			append tokenHelp "<mm> - month" 
			append tokenHelp "<yyyy> - year" 			
			append tokenHelp "<[global function]> - any custom global function" 			
			local tmppath = (getdir #temp) + "tokenhelp.txt"
			(dotnetClass "System.IO.File").WriteAllLines tmppath tokenHelp
			edit tmppath
		)
		on play_Btn Click s e do (
			local prvfilename = resolveFilename filename_etxt.tooltip
			local srcFilenameDic = (getPathInfoDic prvfilename)		
			playPreview playerType srcFilenameDic fps_spnr_.value prvStart prvEnd
		)
		
		on open_Btn Click s e do (
			local prvfilename = resolveFilename filename_etxt.tooltip
			shelllaunch (getFilenamePath prvfilename) ""
		)

		on settings_btn Click s e do (
			try(DestroyDialog ::csMakePreviewSettingsRol)catch() 
			createDIalog csMakePreviewSettingsRol width:360 pos:((getDialogPos csMakePreviewRol) + [60, (getDialogSize csMakePreviewRol).y*(0.7)])
		)

		on saveDefault_btn Click s e do (
			savePreset tofile:true
		)
						
		fn createPrv = (
			local prvfilename = resolveFilename filename_etxt.tooltip
			local srcFilenameDic = (getPathInfoDic prvfilename)			
			
			-- REMOVE EXISTING FILES			
			if srcFilenameDic[#isVideo] then (
				deleteFile prvfilename
			)
			else (
				local existingfiles = (getfiles srcFilenameDic[#getFiles])
				for f in existingfiles do (deleteFile f)
			)			
			
			if srcFilenameDic[#typeonly] == ".mp4" then (		
				prvfilename = srcFilenameDic[#pathonly]  + "\\" + (getDateStr()) + "\\" + srcFilenameDic[#nameonly] + "_.png"
			)
			
			prvfilename = (pathConfig.normalizePath prvfilename)
			makedir (getFilenamePath prvfilename) all:true
			local prvFilenameDic = (getPathInfoDic prvfilename)					
			
			NitrousGraphicsManager.MakePreviewQuality = quallity_spnr_.value					
			local prvStart = animationRange.Start.frame as integer
			local prvEnd =  animationRange.End.frame as integer
			if range_rbtn.state == 2 then (
				prvStart = start_spnr.value as integer
				prvEnd =  end_spnr.value as integer				
			)
			local prvSnippet = snippet_etxt.text
			if not snippet_chkbx.checked then (
				prvSnippet = ""
			)
			local autoPlay = false -- ((doesFileExist chaosPlayerPath) == false and (findItem videoFormats srcFilenameDic[#typeonly]) > 0)

			local prvVpPreset = fnVpPresetEnums[vpPreset_dropdnblst_.selection] 
			local prvVpStyle =   fnVpStyleEnums[vpStyle_dropdnblst_.selection]			
			local edgefaces_chkbx_checked = edgefaces_chkbx_.checked
			local textures_chkbx_checked = textures_chkbx_.checked
 			if useCurrentViewport_chkbtn.checked then (
				local avs = (NitrousGraphicsManager.GetActiveViewportSetting())
				prvVpPreset = fnVpPresetEnums[(findItem viewportPresetEnums avs.ViewportPreset)]
				
				local viewportStyleEnums = #(#Realistic,#Wireframe,#Clay,#Facets,#BoundingBox, #HiddenLine, #ConsistentColors, #modelassist, #Graphite, #ColorPencil, #Ink, #ColorInk, #Acrylic, #Pastel, #Tech)
				local avsViewportStyle = avs.VisualStyleMode
				if avsViewportStyle == #Shaded then avsViewportStyle == #Realistic
				prvVpStyle = fnVpStyleEnums[(findItem viewportStyleEnums avsViewportStyle)]
				
				edgefaces_chkbx_checked = avs.ShowEdgedFacesEnabled 
				textures_chkbx_checked = avs.UseTextureEnabled 
			)
			
			createPreview filename:prvfilename outputAVI:((tolower (getfilenameType prvfilename)) == ".avi") percentSize:sizeperc_spnr.value \ 
			start:prvStart end:prvEnd skip:skip_spnr.value fps:fps_spnr_.value \
			dspGeometry:geometry_chkbx.checked dspShapes:shapes_chkbx.checked dspLights:lights_chkbx.checked \
			dspCameras:cameras_chkbx.checked dspHelpers:helpers_chkbx.checked dspSpaceWarps:spacewarps_chkbx.checked \
			dspParticles:particle_chkbx.checked dspBones:bone_chkbx.checked dspGrid:grid_chkbx.checked \
			dspSafeFrame:safeframe_chkbx.checked dspFrameNums:framenum_chkbx.checked dspCamViewName:camviewName_chkbx.checked \ 
			dspBkg:bg_chkbx.checked  snippet:prvSnippet \
			useMPCamEffect:multipassfx_chkbx.checked autoPlay:autoPlay \
			vpPreset:prvVpPreset vpStyle:prvVpStyle \
			vpEdgedFaces:edgefaces_chkbx_checked vpTextures:textures_chkbx_checked 


			local uiVals = (savePreset tofile:false)
			
			if srcFilenameDic[#typeonly] == ".mp4" and (doesFileExist ffmpegPath) then (		
				progressStart "Generating mp4" 
				local mp4path = srcFilenameDic[#filepath]  				
				local deleteTmp = true
				local askDeleteTemp = false
				deleteFile mp4path
				if (doesFileExist mp4path) then (
					askDeleteTemp = false
				)
				else (
					local imgseq  = (substitutestring prvFilenameDic[#strformat] "%" "%%")
					local batArr = #()
					append batArr ((filterstring ffmpegPath ":")[1] + ":")
					append batArr ("cd \"" + (getFilenamePath ffmpegPath) + "\"")
					local ffmpegcmdtrstrm = StringStream ""
					format "ffmpeg -r % -start_number % -i \"%\" -vcodec libx264 -crf 15 -pix_fmt yuv420p -y \"%\"" fps_spnr_.value  prvStart imgseq mp4path to:ffmpegcmdtrstrm
					append batArr (ffmpegcmdtrstrm as string)
					local batFilename = prvFilenameDic[#pathonly]  + "\\" + prvFilenameDic[#nameonly] + ".bat"			
					(dotnetClass "System.IO.File").WriteAllLines batFilename batArr
					local stdout = hiddendoscommand batFilename startpath:(getFilenamePath ffmpegPath) donotwait:false
					if not (doesFIleExist mp4path) then askDeleteTemp = true

				)
				if askDeleteTemp then (
					deleteTmp = (queryBox "Failed to convert to mp4. Do you want to delete temp preview files?")	
				)				
				if deleteTmp then (
					local existingfiles = (getfiles (prvFilenameDic[#pathonly] + "\\*.*"))
					for f in existingfiles do (deleteFile f)		
					removeDir prvFilenameDic[#pathonly]
				)				
				progressUpdate 100
				progressEnd()
			)

			if autoPlay == false and playwhendone_chkbx_.checked then (
				playPreview playerType srcFilenameDic fps_spnr_.value prvStart prvEnd
			)
		)		
		on create_btn pressed do (
			createPrv()
		)
		
		on cancel_btn pressed do (
			try(DestroyDialog csMakePreviewRol)catch()
		)
		
	)
	if (try((maxversion())[8] > 2023)catch(false)) then (
		createDialog csMakePreviewRol width:420 -- modal:true -- height:648
	)
	else(
		messagebox "3dsMax 2024+ only"
	)
)