macroScript CollapseSW
		category:"csTools" 
		tooltip:"Collapse/PointCacheSW"
		buttontext:"CollapseSW"
(
	global CollapseSWRol
	try(destroyDialog CollapseSWRol)catch()
	local rolWidth = 180
	rollout CollapseSWRol "CollapseSpaceWarp" (
		group "" (
		radiobuttons staticOrDeformRdobtn "" labels:#("Collapse", "PointCache") default:1
		button collapseBtn "Collapse" width:(rolWidth-16) 
		progressBar prgrsBr "" width:(rolWidth-16) color:orange
		)
		group "PointCache File" (
			label filenameLbl "FileName:"align:#left enabled:false
			button fileNameBtn "Select" width:(rolWidth-16) enabled:false
			checkbox folderPerObjChkbx "Make SubDir Per Obj" default:false enabled:false
		)
		group "PointCache Paramaters" (
			radiobuttons oneFIleRdobtn "" labels:#("One File", "One File Per Frame") align:#left default:1 enabled:false
			spinner startSpnr "Start              " range:[-99999,99999, animationRange.Start.frame] type:#integer fieldwidth: 54 align:#right enabled:false
			spinner endSpnr "End Frame     " range:[-99999,99999, animationRange.End.frame] type:#integer fieldwidth: 54 align:#right enabled:false
			label sampleRateLbl "Sample Rate:"  align:#left enabled:false
			label sampleRateLbl2 "Sameple Every Nth Frame"  align:#left enabled:false			 
			spinner sampleRateSpnr "" range:[0,999, 1] type:#float fieldwidth: 54 align:#right enabled:false		
		)
		
		on CollapseSWRol open do (
			if collapseSW == undefined then (
				messagebox "Install CollapseSW MCG first.\nVisit www.changsooeun.com"
				try(destroyDialog CollapseSWRol)catch()				
			)
			else(
				if selection.count == 1 then (
					folderPerObjChkbx.checked = false
				)
				else(
					folderPerObjChkbx.checked = true
				)
			)
		)
		on staticOrDeformRdobtn changed arg do (
			if arg == 1 then (
				collapseBtn.text = "Collapse"
				for c in CollapseSWRol.controls do (
					if c != staticOrDeformRdobtn and c != collapseBtn  then c.enabled = false
				)
			)
			if arg == 2 then (
				collapseBtn.text = "PointCache"
				for c in CollapseSWRol.controls do c.enabled = true
			)
		)
		on fileNameBtn pressed do (
			if selection.count == 0 then (
				messagebox "Select Object(s) First."
			)
			else (
				local pcFileName = (getSaveFileName caption:"Save Cache" filename: ((selection[1].name + ".xml")))
				if pcFileName != undefined then fileNameBtn.text = fileNameBtn.tooltip = pcFileName
			)
		)
		on collapseBtn pressed do (
			if selection.count == 0 then (
				messagebox "Select Object(s) First."
			)
			else (
				local objsHasSW = #()
				for o in selection do (
					if o.modifiers.count > 0 then (
						if (for m in o.modifiers where ((superclassof m) == SpacewarpModifier) collect m).count > 0 then (
							append objsHasSW o
						)
						else(
							format "CollapseSW: % does not have spacewarp(s).\n" o.name 
						)
					)
					else(
						format "CollapseSW: % does not have modifier(s).\n" o.name 
					)
				)
				if objsHasSW.count > 0 then (
					if staticOrDeformRdobtn.state == 1 then (
						clearSelection()						
						for o in objsHasSW do (
							windows.processPostedMessages()
							local tmpCollapseSW = CollapseSW()
							tmpCollapseSW.source = o
							convertTo tmpCollapseSW (classof o)
							for i = o.modifiers.count to 1 by -1 do (
								deleteModifier o o.modifiers[i]
							)
							o.baseObject = tmpCollapseSW.baseObject
							format "CollapseSW: % Collapsing...\n" o.name 						
							delete tmpCollapseSW
							prgrsBr.value = (prgrsBr.value + (100/objsHasSW.count)) as integer
						)
						gc light:true
						messageBox "Collapse/PointCache SW : Done"
					)
					if staticOrDeformRdobtn.state == 2 then (
						if (substituteString fileNameBtn.tooltip " " "") == "" then (
							messagebox "Select Cache Filename First."
						)
						else (
							clearSelection()
							for o in objsHasSW do (
								windows.processPostedMessages()
								local tmpCollapseSW = CollapseSW()
								tmpCollapseSW.source = o
								
								local tmpPC = pointcache()
								addmodifier tmpCollapseSW tmpPC
								if objsHasSW.count == 1 then (
									tmpPC.filename = fileNameBtn.tooltip
								)
								else(
									local pcPath = (getFilenamePath fileNameBtn.tooltip)
									local pcExt = (getFilenameType fileNameBtn.tooltip)
									if folderPerObjChkbx.state == false then (
										makedir pcPath all:true
										tmpPC.filename = pcPath + o.name + pcExt
									)
									else(
										local perObjectDir = pcPath + o.name + "\\"
										makedir perObjectDir all:true								
										tmpPC.filename = perObjectDir + o.name + pcExt
									)
								)
								if tolower(getFilenameType fileNameBtn.tooltip) == ".pc" then (
									tmpPC.fileCount = 0
								)
								else(
									tmpPC.fileCount =  (oneFIleRdobtn.state - 1)
								)
								tmpPC.recordStart  = startSpnr.value
								tmpPC.recordEnd = endSpnr.value
								tmpPC.sampleRate  = sampleRateSpnr.value
								format "CollapseSW: % Generating PointCache...\n" o.name 
								cacheOps.RecordCache tmpPC

								addmodifier o tmpPC
								for m in o.modifiers do (
									if ((superclassof m) == SpacewarpModifier) then m.enabled = false
								)
								delete tmpCollapseSW
								prgrsBr.value = (prgrsBr.value + (100.0/objsHasSW.count)) as integer
							)
							gc light:true	
							messageBox "Collapse/PointCache SW : Done"							
						)
					)
					prgrsBr.value = 0
				)
			)
		)

	)
	createDIalog CollapseSWRol width:rolWidth pos:mouse.screenpos
)
