-- By Changsoo Eun
-- https://cganimator.com/csmakepreview-1-21/
-- Drag and drop to a viewport or copy to usermacros folder.
macroScript csSetVptClipping
	category:"csTools"
	buttontext:"csSetViewportClipping"
	toolTip:"csSetViewportClipping"
(

	global csSetVptClipping_rol
	try(DestroyDialog ::csSetVptClipping_rol)catch()
	rollout csSetVptClipping_rol "csSetVptClipping" width:140 (
		checkbutton clippingplane_chk "Clipping Plane" width:(csSetVptClipping_rol.width - 16)
		spinner near_spnr "Near" range:[0.0, 1.1, 0.000] scale:0.001
		spinner far_spnr "Far" range:[0.0, 1.1, 1.000] scale:0.001
		button reset_btn "Reset" width:(csSetVptClipping_rol.width - 16)
		
		fn UpdateUI = (
			vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			clippingplane_chk.checked = vpSetting.ViewportClippingEnabled 
			near_spnr.value = vpSetting.ViewportClipNear 
			far_spnr.value = vpSetting.ViewportClipFar 		
		)	
		
		on csSetVptClipping_rol open do (
			local vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			if (isProperty vpSetting #ViewportClippingEnabled) then (
				callbacks.removeScripts id:#csSetVptClipping
				callbacks.addScript #activeViewportChanged "try(csSetVptClipping_rol.updateUI())catch()" id:#csSetVptClipping			
				UpdateUI()				
			)
			else(
				messagebox "Only suppports 2024.2+"
			)
		)
		on csSetVptClipping_rol close do (
			try(DestroyDialog csSetVptClipping_rol)catch()
		)
		on clippingplane_chk changed arg do ( 
			local vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			vpSetting.ViewportClippingEnabled = arg	
		)
		on near_spnr changed arg do ( 
			local vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			if arg >= vpSetting.ViewportClipFar then (
				vpSetting.ViewportClipFar = arg
				far_spnr.value = arg
			)
			vpSetting.ViewportClipNear = arg	
		)
		on far_spnr changed arg do ( 
			local vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			if arg <= vpSetting.ViewportClipNear then (
				vpSetting.ViewportClipNear = arg
				near_spnr.value = arg
			)
			vpSetting.ViewportClipFar = arg	
		)		
		on reset_btn pressed do ( 
			local vpSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			vpSetting.ResetViewportClipNearFar()	
			UpdateUI()		
		)
	)
	try(DestroyDialog csSetVptClipping_rol)catch()
	createDIalog csSetVptClipping_rol 

)