macroScript AutoFrost tooltip:"Select a Frost object and toggle to add newly created objects to it automatically..." category:"Frost" icon:#("Frost",2)
(
global FrostSphereGizmoAutoAdd_System, FrostSphereGizmoAutoAdd_Function
fn FrostSphereGizmoAutoAdd_Function val =
(
	try
	(
		if isValidNode ::FrostSphereGizmoAutoAdd_System do(
			if finditem #(ParticleGroup) (classof val) == 0 do(
				--if a PRT Loader is about to be created from the current Frost system, this would lead to a dependency loop and should be avoided:
				if classof val == PRT_Volume and selection.count == 1 and selection[1] == ::FrostSphereGizmoAutoAdd_System do return false
				append ::FrostSphereGizmoAutoAdd_System.nodeList val
				if superclassof val == Shape do 
				(
					val.optimize = false
					val.steps = 50
				)
			)
			FrostUtils.LogProgress("+AUTO-FROST: Added " + (val.name as String) + " to " + (::FrostSphereGizmoAutoAdd_System.name as String))
		)
	)catch(FrostUtils.LogProgress("--AUTO-FROST: Failed To Add " + (val.name as String) + "..."))
)

on isChecked return isValidNode ::FrostSphereGizmoAutoAdd_System 
on isEnabled return Frost != undefined	
on execute do
(
	callbacks.removeScripts id:#FrostSphereGizmoAutoAdd
	if isValidNode ::FrostSphereGizmoAutoAdd_System then
	(
		::FrostSphereGizmoAutoAdd_System = undefined
		FrostUtils.LogProgress "--AUTO-FROST: Turned Off!"
	)
	else
	(
		if (selection.count == 1 and classof $.baseobject == Frost) then
			::FrostSphereGizmoAutoAdd_System = $
		else
		(
			theFrosts = for o in objects where classof o.baseobject == Frost collect o
			if theFrosts.count > 0 do 
				::FrostSphereGizmoAutoAdd_System = theFrosts[theFrosts.count]
		)
		if isValidNode ::FrostSphereGizmoAutoAdd_System then
		(
			callbacks.addScript #nodeCreated "::FrostSphereGizmoAutoAdd_Function (callbacks.notificationParam())" id:#FrostSphereGizmoAutoAdd
			FrostUtils.LogProgress("AUTO-FROST: Enabled For " + (::FrostSphereGizmoAutoAdd_System.name as String))
			::FrostSphereGizmoAutoAdd_System.updateOnParticleChange = true
			::FrostSphereGizmoAutoAdd_System.useRadiusChannel = true
		)
		else
			FrostUtils.LogError "--Failed To Enable Auto-Frost.  Please create a Frost object first."
	)
)

)--end script
