macroScript CreateFrost category:"Frost" buttontext:"Frost" tooltip:"FROST Particle Mesher - Select Source(s) and Click to Create, or Hold SHIFT to Create Manually in the Viewport" icon:#("Frost",1)
(
	on isChecked return  (try(mcrUtils.IsCreating Frost)catch(false)) 
	on isEnabled return Frost != undefined	
	on execute do 
	(
		local theObjects = (for o in selection where (findItem shape.classes (classof o) > 0) OR  (classof o == SphereGizmo) OR (findItem GeometryClass.classes (classof o) > 0 AND (classof o) != TargetObject AND (classof o) != ParticleGroup) collect o) 
		if keyboard.shiftPressed or theObjects.count == 0 then
		(
			StartObjectCreation Frost
		)
		else
		(
			local oldTaskMode = getCommandPanelTaskMode()
			try
			(
				theCenter = selection.center
				theColor = color 0 0 0
				for o in theObjects do theColor += o.wirecolor
				theColor /= theObjects.count
				local newFrost = Frost()
				select newFrost
				setCommandPanelTaskMode #modify
				newFrost.pos = theCenter
				newFrost.wirecolor = theColor
				newFrost.iconsize = 50.0
				newFrost.nodeList = theObjects 
			)
			catch
			(
				messagebox "One or more selected objects were not valid particle sources.\nPlease make sure all selected objects are valid!" title:"Failed to Add to Frost"
			)
			setCommandPanelTaskMode oldTaskMode
		)
	)
)
