macroScript csStackCache
	category:"csTools"
	buttontext:"csStackCache"
	toolTip:"csStackCache"
(

	global csStackCache_rol
	try(DestroyDialog ::csStackCache_rol)catch()
	rollout csStackCache_rol "csStackCache 0.9" (
		radiobuttons rbtnSel "" labels:#("All", "Selection", "Selection Set") align:#center offset:[-6, 6] columns:3 offsets:#([12,0], [-12,0],[-12,0])
		dropdownlist drpdnlstSelectionSet "" items:#() align:#center offset:[0, 0] width:(csStackCache_rol.width - 20)
		progressbar prgbar "" width:(csStackCache_rol.width - 20) align:#center offset:[0, 0]
		button btnCache "Cache" width:(csStackCache_rol.width - 20) height:36
		button btnAddCache "Add Cache" width:((csStackCache_rol.width - 20)/2) offset:[-2, 0] across:2
		button btnRemoveCache "Remove Cache" width:((csStackCache_rol.width - 20)/2) offset:[2, 0]

		local csStackCacheName = "csStackCache"
		local selDataID = 12312023
		fn getSelObjs = (
			local sel = #()
			if rbtnSel.state == 1 then (
				sel = (geometry as array)
			)
			if rbtnSel.state == 2 then (
				sel = (for o in (selection as array) where (superclassof o) == GeometryClass collect o)
			)			
			if rbtnSel.state == 3 and drpdnlstSelectionSet.selected !=undefined and drpdnlstSelectionSet.items.count > 0 then (
				sel = (for i = 1 to selectionSets[drpdnlstSelectionSet.selected].count collect selectionSets[drpdnlstSelectionSet.selected][i])
			)
			for o in sel where o.modifiers.count > 0 do (
				local csStackCacheMod = o.modifiers[csStackCacheName]
				if csStackCacheMod != undefined then (
					setAppdata csStackCacheMod selDataID "false"
				)
			)
			sel
		)	
		fn getFirstEnabledModIdx o = (	
			i = 0
			local m = undefined 
			local firstEnabled = true
			do (
				i += 1
				m = o.modifiers[i]						
				firstEnabled = (m.enabled and m.enabledInViews)
			)
			while (firstEnabled == false)
			i
		)
		fn doCache o subMod i = (
			local onOffBackup = #()
			if subMod != undefined then (
				local subModCheck = (getAppdata subMod selDataID)
				if subModCheck != undefined and subModCheck == "true" then (
					format "\talreafy cached\n"
					return undefined
				)				
				local subModIdx = (modPanel.getModifierIndex o subMod)
				for i = 1 to subModIdx do (
					local m = o.modifiers[i]
					append onOffBackup #(i, m.enabled, m.enabledInViews, m.enabledInRenders)
					m.enabled = false
				)
				subMod.enabled = false
			)
			
			local cacheObj = (copy o) 
			convertTo cacheObj (classof o)
			cacheObj.parent = o.parent
			cacheObj.transform = o.transform

			for onOff in onOffBackup do (
				local mIdx = onOff[1]
				local m = o.modifiers[mIdx]
				m.enabled = onOff[2]
				m.enabledInViews = onOff[3]
				m.enabledInRenders = onOff[4]
			)
			
			if subMod == undefined then (
				subMod = (SubstituteMod name:csStackCacheName)
				addModifier o subMod before:(i - 1)				
			)
			else (
				subMod.enabled = true
			)
			subMod.DisplayInViewport = true
			subMod.DisplayInRender = true
			subMod.MoveCopyInstance = 2
			subMod.RetainPosition = true
			subMod.RetainLocalRotation = true
			subMod.RetainLocalScale = true
			subMod.ObjectReference = cacheObj
			setAppdata subMod selDataID "true"
			cacheObj
		)
		fn UpdateAppData = (
			local selSS = ""
			if drpdnlstSelectionSet.selected != undefined then (
				selSS = drpdnlstSelectionSet.selected
			)
			setAppdata rootnode selDataID (#(rbtnSel.state, selSS) as string)
		)
		fn UpdateUI = (
			local ssnames = (for i = 1 to selectionSets.count collect (selectionSets[i].name as string))
			qsort ssnames stricmp 
			drpdnlstSelectionSet.items = ssnames			
			local selData = (getAppdata rootnode selDataID)
			if selData != undefined then (
				local selDataVal = try(execute selData)catch(#())
				if selDataVal.count > 1 then (
					rbtnSel.state = selDataVal[1]
					drpdnlstSelectionSet.selection = (findItem drpdnlstSelectionSet.items selDataVal[2])
				)
			)
		)	
		
		on csStackCache_rol open do (
			UpdateUI()
		)

		on rbtnSel changed arg do (
			UpdateAppData()
			UpdateUI()
		)
		on drpdnlstSelectionSet selected arg do (
			UpdateAppData()
		)
		on btnCache pressed do (
			local st = (timeGetTime())
			setCommandPanelTaskMode #create 
			clearSelection()
			with undo off, with redraw off (
				local caches = #()
				local sel = (getSelObjs())
				prgbar.color = black
				local o2cache = (for o in sel where o.modifiers.count > 0 collect o)
				local count = 1
				for o in o2cache do (
					prgbar.color = yellow
					prgbar.value = (((count/(o2cache.count as float))*100.0) as integer)
					local subMod = o.modifiers[csStackCacheName] 
					format "%/%\t[%]%\n" count o2cache.count (subMod == undefined) o.name
					if subMod == undefined then (
						local firstEnabledModIdx = (getFirstEnabledModIdx o)
						local cacheObj=(doCache o undefined firstEnabledModIdx)
						append caches cacheObj					
					)
					else (
						local cacheObj=(doCache o subMod 1)
						append caches cacheObj 						
					)
					count += 1			
				)
				delete (for o in caches where (isValidNode o) collect o)
				prgbar.color = green
				gc light:true
			)	
			local dur = ((timeGetTime()) - st)/1000.0
			format "csStackCache - caching finished in %s\n" dur
		)
		on btnAddCache pressed do (
			local st = (timeGetTime())
			setCommandPanelTaskMode #create 
			clearSelection()
			with undo off, with redraw off (			
				local sel = (getSelObjs())
				prgbar.color = black					
				local o2clean = (for o in sel where o.modifiers.count > 0 collect o)
				local count = 1
				for o in o2clean do (		
					prgbar.color = yellow
					prgbar.value = (((count/(o2clean.count as float))*100.0) as integer)
 	 				local subMod = o.modifiers[csStackCacheName] 
					format "%/%\t[%]%\n" count o2clean.count (subMod == undefined) o.name					
					if subMod == undefined then (
						local firstEnabledModIdx = (getFirstEnabledModIdx o)
						local subMod = (SubstituteMod name:csStackCacheName)
						addModifier o subMod before:(firstEnabledModIdx - 1)		
					)
					count += 1					
				)
				prgbar.color = green
				gc light:true	
			)
			local dur = ((timeGetTime()) - st)/1000.0
			format "csStackCache - adding cache mod finished in %s\n" dur					
		)
		on btnRemoveCache pressed do (
			local st = (timeGetTime())
			setCommandPanelTaskMode #create 
			clearSelection()
			with undo off, with redraw off (			
				local sel = (getSelObjs())
				prgbar.color = black					
				local o2clean = (for o in sel where o.modifiers.count > 0 collect o)
				local count = 1
				for o in o2clean do (		
					prgbar.color = yellow
					prgbar.value = (((count/(o2clean.count as float))*100.0) as integer)
 	 				format "%/%\t%\n" count o2clean.count o.name				
					count += 1
					local subMod = o.modifiers[csStackCacheName]
					if subMod != undefined then (
						deleteModifier o subMod
					)
				)
				prgbar.color = green
				gc light:true	
			)
			local dur = ((timeGetTime()) - st)/1000.0
			format "csStackCache - removing cache finished in %s\n" dur			
		)
	)
	createDIalog csStackCache_rol 224 148

)