-- csSyncPersToCam v1.1
-- by Changsoo Eun
-- www.cganimator.com

global csSyncPersToCam_rol
macroScript csSyncPersToCam
	category:"csTool"
	toolTip:"csSyncPersToCam"
(
-- 	cam = $PhysCamera001
	try(DestroyDialog csSyncPersToCam_rol)catch()
	global syncPers2Cam
	fn syncPers2Cam cam = (
		if (isValidNode cam) and (viewport.getType()) == #view_persp_user \ 
		and (isProperty cam #fov) then (
			cam.fov = (viewport.getfov())
			local vptWorldTm = (inverse(viewport.getTM()))
			cam.transform = vptWorldTm  -- (translate vptWorldTm [0, 0, 0])
		)
	)		
	rollout csSyncPersToCam_rol "csSyncPersToCam 1.1" (
		dropdownlist cam_drpdnlist "Camera to Sync"
		label lbl0 "* Make sure to set camera to use FOV"
		label lbl1 "* Target camera is not supported"
		checkbutton sync_btn "Sync" width:(csSyncPersToCam_rol.width - 24)
		
		local cam = undefined 
		
		on csSyncPersToCam_rol open do (
			cam_drpdnlist.items = (for o in cameras where (isProperty o #fov) collect o.name)
		)		
		on csSyncPersToCam_rol close do (
			callbacks.removeScripts id:#syncPers2Cam					
		)
		on sync_btn changed arg do (
			callbacks.removeScripts id:#syncPers2Cam			
			if cam_drpdnlist.items.count > 0 and arg then (
				cam = (getNodeByName cam_drpdnlist.items[cam_drpdnlist.selection])
				callbacks.addScript #viewportChange "syncPers2Cam csSyncPersToCam_rol.cam" id:#syncPers2Cam	
				syncPers2Cam cam
			)
		)
	)
	CreateDialog csSyncPersToCam_rol width:240
)