-------------------------------------------------------------------------------
-- csWorkPlane 
-- by Changsoo Eun
-- www.changsooeun.com
-- 1.51 : csWorkPlaneUI added /  autoAutogrid renamed as Place Grid
-- 1.0 : Initial release.
--
-- How to install
-- 1) Evaulate this script(CTRL-E) or just drag and drop .ms file into viiewport.
-- Make a shorcut or button. All scripts are in "csTools" cetegory
-------------------------------------------------------------------------------
macroScript autoAutogrid category:"csTools" buttonText:"Place Grid" tooltip:"Place Grid : allow you create a grid object. After the grid is made, the grid will be automatically activated, and all transform coodinates will be set to Grid. If you want to go back to the default coordinate, Run this script again while pressing SHIFT"
(
	macros.run "csTools" "RemoveWorkPlane"
	if keyboard.shiftPressed == false then (
		autoAutogrid = undefined
		gc light:true
		maxOps.autoGrid = true
		startObjectCreation grid
		fn autoAutogridFn ev nd = (
			local obj = (GetAnimByHandle nd[1])
			global workplane = obj
			if (classof obj) == grid then (
				local objTM = obj.transform
				local objPos = obj.pos
				obj.pos = objPos + (objTM.row1*obj.width*(-0.5)) +  (objTM.row2*obj.length*(0.5)) 
				max activate grid object
				maxOps.autoGrid = false
				toolmode.commandmode = #ROTATE 
				toolMode.coordsys #grid			
				toolmode.commandmode = #USCALE
				toolMode.coordsys #grid		
				toolmode.commandmode = #MOVE 
				toolMode.coordsys #grid	
				autoAutogrid = undefined	
				gc light:true
			)
		)
		autoAutogrid = NodeEventCallback mouseUp:true delay:1000 Added:autoAutogridFn
	)
)

macroScript LockWorkPlaneToOrigin category:"csTools" buttonText:"LockWorkPlaneToOrigin" tooltip:"LockWorkPlaneToOrigin : If you turn on this mode, the plane which face to camera will automatically become the construction plane. If you want to go back to the default coordinate, Run this script again while pressing SHIFT"
(
	macros.run "csTools" "RemoveWorkPlane"
	if keyboard.shiftPressed == false then (
		global workplane = (grid name:"workPlane" grid:10.0)
		format "-- Genrating WorkPlane.\n"	
		
		local tmpSelection = (selection as array)
		select workplane
		max activate grid object
		select tmpSelection		
		
		global getViewDirection
		fn getViewDirection = (
			workplane.width = workplane.length = 1000.0
			local coordSysTM = Inverse(getViewTM())
			local viewMinusZ = (normalize coordSysTM.row3)
			local planes = #([1, 0, 0],[0, 1, 0],[0, 0, 1],[-1, 0, 0],[0, -1, 0],[0, 0, -1])		
			dots = (for pn in planes collect (dot viewMinusZ pn))
			workplane.transform = matrixFromNormal (planes[(findItem dots (amax dots))])
		)
		callbacks.addScript #viewportChange "getViewDirection()" id:#lockWorkPlaneToOrigin 
	)
)

macroScript RemoveWorkPlane category:"csTools" buttonText:"RemoveWorkPlane" tooltip:"RemoveWorkPlane : Turn off workplane by deleteing the workplane from the scene. It is same as SHIFT+LockWorkPlaneToOrigin"
(
	callbacks.removeScripts id:#lockWorkPlaneToOrigin
	callbacks.removeScripts id:#lockWorkPlaneToVIew
	try(delete workplane)catch()
)

macroScript AlignWorkplaneToFaceSelection category:"csTools" buttonText:"AlignWorkplaneToFaceSelection"tooltip:"AlignWorkplaneToFaceSelection : 1) Select an object 2)select face(s) 3)Run this script. This script will make a grid object at the center of face and activate it. The ZAxis will be aligned to face normal."
(
	macros.run "csTools" "RemoveWorkPlane"
	fn placeGridOnSelectedFace = (
		local o = selection[1]
		local omesh = o.mesh
		local totalPos = [0,0,0]
		local totalNormal = [0,0,0]
		
		local selFaces = omesh.selectedFaces
		if selFaces.count > 0 then (
			for fc in selFaces do (
				totalPos = totalPos + (meshop.getFaceCenter omesh fc.index)
				totalNormal = totalNormal + (meshop.getFaceRNormals omesh fc.index)[1]		
			)
			local center = totalPos/selFaces.count		
			local normal = totalNormal/selFaces.count

			local selVerts = ((meshop.GetVertsUsingFace omesh selFaces) as array)
		
			local firstEdge = normalize((meshop.getVert omesh selVerts[2])  - (meshop.getVert omesh selVerts[1]))
			local xaxis = cross normal firstEdge
			local yaxis = cross  normal xaxis
			local gridTm = (matrix3 (normalize xaxis)  (normalize yaxis) normal center)
			local worldTM = gridTm*o.transform

			global workplane = (grid name:"workPlane" grid:10.0)
			format "-- Genrating WorkPlane.\n"	
			
			workplane.width = workplane.length = (distance o.min o.max)
			workplane.transform = worldTM
			local tmpSelection = (selection as array)
			select workplane
			max activate grid object
			select tmpSelection
			toolmode.commandmode = #ROTATE 
			toolMode.coordsys #grid			
			toolmode.commandmode = #USCALE
			toolMode.coordsys #grid		
			toolmode.commandmode = #MOVE 
			toolMode.coordsys #grid				
		)
		else(
			messagebox "Select face(s) on an object"
		)
	)
	if selection.count == 1 and (canConvertTo selection[1] editable_mesh) == true then (
		placeGridOnSelectedFace() 
	)
	else(
		messagebox "Select a Face on a Mesh"
	)
)

macroScript LockWorkPlaneToVIew category:"csTools" buttonText:"LockWorkPlaneToView" tooltip:"LockWorkPlaneToVIew : If you turn on this mode, the construction plane will be aligned to your view. If you want to go back to the default coordinate, Run this script again while pressing SHIFT"
(
	macros.run "csTools" "RemoveWorkPlane"
	if keyboard.shiftPressed == false then (
		global workplane = (grid name:"workPlane" grid:10.0)
		format "-- Genrating WorkPlane.\n"				

		local tmpSelection = (selection as array)
		select workplane
		max activate grid object
		select tmpSelection		
		
		global getViewDirection
		fn getViewDirection = (
			workplane.width = workplane.length = 1000.0
			workplane.transform = Inverse(getViewTM())
			workplane.pos = [0,0,0]
		)
		callbacks.addScript #viewportChange "getViewDirection()" id:#lockWorkPlaneToVIew 
	)
)

macroScript csWorkPlaneUI category:"csTools" buttonText:"csWorkPlaneUI" tooltip:"csWorkPlaneUI" 
(
	global csWorkPlaneUI
	try(cui.FloatDialogBar csWorkPlaneUI)catch()
	try(cui.UnRegisterDialogBar csWorkPlaneUI)catch()
	try(destroyDialog csWorkPlaneUI)catch()
	rollout csWorkPlaneUI "csWorkPlane" (
		button autoAutogridBtn "Place Grid" width:90	align:#center
		group "WorkPlane" (
			button LockWorkPlaneToOriginBtn "Lock 2 Origin" width:90 align:#center
			button LockWorkPlaneToVIewBtn "Lock 2 View" width:90 align:#center		
			button AlignWorkplaneToFaceSelectionBtn "Align 2 FaceSel." width:90 align:#center
			button RemoveWorkPlaneBtn "Remove " width:90 align:#center
		)
		on autoAutogridBtn rightclick do (cui.FloatDialogBar csWorkPlaneUI)
		on LockWorkPlaneToOriginBtn rightclick do (cui.FloatDialogBar csWorkPlaneUI)
		on LockWorkPlaneToVIewBtn rightclick do (cui.FloatDialogBar csWorkPlaneUI)	
		on AlignWorkplaneToFaceSelectionBtn rightclick do (cui.FloatDialogBar csWorkPlaneUI)	
		on RemoveWorkPlaneBtn rightclick do (cui.FloatDialogBar csWorkPlaneUI)	
		
		on autoAutogridBtn pressed do (macros.run "csTools" "autoAutogrid")
		on LockWorkPlaneToOriginBtn pressed do (macros.run "csTools" "LockWorkPlaneToOrigin")
		on LockWorkPlaneToVIewBtn pressed do (macros.run "csTools" "LockWorkPlaneToVIew")	
		on AlignWorkplaneToFaceSelectionBtn pressed do (macros.run "csTools" "AlignWorkplaneToFaceSelection")
		on RemoveWorkPlaneBtn pressed do (macros.run "csTools" "RemoveWorkPlane")
		
	)
	createDialog csWorkPlaneUI 98 148
	cui.RegisterDialogBar csWorkPlaneUI
)
