 -- MaxFluidsPRTExportChannelSetup
 -- By Changsoo Eun
 -- www.changsooeun.com
PRTChSetForm
macroScript MaxFluidsPRTExportChannelSetup category:"csTools" buttonText:"MaxFluidsPRTExportChannelSetup" toolTip:"MaxFluids PRT Export Channel Setup"
(
	 try(PRTChSetForm.close()) catch()
	(
		local dgvWidth = 220
		local PRTchannels = #(#position,#density,#velocity,#vorticity,#id,#age,#airDistance,#churn,#curvature,#droplet,#expansionRate,#stictionStrength,#stictionBandwidth,#uv)

		PRTChSetForm = dotnetobject "MaxCustomControls.Maxform"
		PRTChSetForm.Text = "MaxFluid PRT Export Chennel Setup"	
		PRTChSetForm.width = dgvWidth + 17
		PRTChSetForm.height = 370
		PRTChSetForm.FormBorderStyle = PRTChSetForm.FormBorderStyle.FixedDialog

		local dgv = dotnetobject "DataGridView"
		
		fn iniDGV = (
			dgv.Dock = dgv.Dock.Fill
			dgv.readOnly = false
			dgv.ColumnHeadersVisible = true
			dgv.RowHeadersVisible = false			
			dgv.AllowUserToDeleteRows = false
			dgv.AllowUserToAddRows = false
			dgv.AllowUserToOrderColumns = true
			dgv.AllowUserToResizeRows = false			
			dgv.BorderStyle = (dotnetclass "System.Windows.Forms.BorderStyle").none
			dgv.MultiSelect = false
			dgv.SelectionMode = (dotnetclass "System.Windows.Forms.DataGridViewSelectionMode").CellSelect
			dgv.EditMode = dgv.EditMode.EditOnEnter
			
			local dotnetColor = (dotNetClass "System.Drawing.Color")
			dgv.BackgroundColor = dotnetColor.dimgray
			dgv.BackColor = dotnetColor.dimgray 
			dgv.ForeColor = dotnetColor.white 
			dgv.gridcolor = dotnetColor.gray
			dgv.DefaultCellStyle.BackColor = dotnetColor.dimgray 
			dgv.DefaultCellStyle.ForeColor = dotnetColor.white 
		)
		fn setColumn = (	
			local col_1 = dotNetObject "System.Windows.Forms.DataGridViewTextBoxColumn"
			col_1.headerText = "Channel"
			col_1.width = 90
			col_1.readonly = true
			
			local col_2 = dotNetObject "System.Windows.Forms.DataGridViewTextBoxColumn"
			col_2.headerText = "Custom name"
			col_2.width = 90
			
			local col_3 = dotNetObject "System.Windows.Forms.DataGridViewCheckBoxColumn"
			col_3.headerText = "On/Off"
			col_3.width = (dgvWidth - col_1.width - col_2.width)
			
			dgv.columns.add col_1
			dgv.columns.add col_2
			dgv.columns.add col_3
		)	
		fn fillDGV = (
			dgv.rows.clear()
			for i = 1 to PRTchannels.count do (
				local tmpRow = dgv.rows.item[dgv.rows.add()]
				tmpRow.cells.item[0].value = (PRTchannels[i] as string)
				local ch_user_name = "q"
				PRTExport.GetExportName PRTchannels[i] &ch_user_name
				tmpRow.cells.item[1].value = ch_user_name
				tmpRow.cells.item[2].value = (PRTExport.GetExportOption PRTchannels[i])
			)			
			dgv.update()
		)	
		iniDGV()
		setColumn()
		fillDGV()
		
		fn dgv_CellValueChanged s e = (
			if ((e.RowIndex != -1) and (e.ColumnIndex != -1))do (
				local theCell = dgv.rows.item[e.RowIndex].cells.item[e.ColumnIndex]
				local theCellValue = theCell.value
				if (classof theCellValue) == BooleanClass then (
					local PRTChName = (dgv.rows.item[e.RowIndex].cells.item[0].value as name)
					PRTExport.SetExportOption PRTChName theCellValue
					format "Setting PRT Export Channel [ % ] = %\n" PRTChName theCellValue
				)
			)		
		)
		dotNet.AddEventHandler dgv "CellValueChanged" dgv_CellValueChanged
		
		fn dgv_CurrentCellDirtyStateChanged s e = (
			dgv.commitEdit (dotNetClass "DataGridViewDataErrorContexts").commit
		)
		dotNet.AddEventHandler dgv "CurrentCellDirtyStateChanged" dgv_CurrentCellDirtyStateChanged
		
		fn dgv_CellEndEdit s e = (
			if ((e.RowIndex != -1) and (e.ColumnIndex != -1))do (
				local theCell = dgv.rows.item[e.RowIndex].cells.item[e.ColumnIndex]
				local theCellValue = theCell.value
				if (classof theCellValue) == String then (
					local PRTChName = (dgv.rows.item[e.RowIndex].cells.item[0].value as name)
					format "Setting PRT Export Channel Name [ % ] = %\n" PRTChName theCellValue
					PRTExport.SetExportName PRTChName theCellValue				
				)
			)			
		)
		dotNet.AddEventHandler dgv "CellEndEdit" dgv_CellEndEdit
		PRTChSetForm.controls.add dgv
		PRTChSetForm.showmodeless()
	)
)