------------------------------------------give you head up  -------------------------------------
-- csMergeBy
-- by Changsoo Eun
-- www.changsooeun.com
-- 
-- It allow you to merge by Layer, SelectionSet, ObjectID and Material name.
-- To use this tool, the .max file must have the scene data which is generated by csMergeBySave.ms.
-- Put csMergeBySave.ms file into startup folder or one of plugins folder
-- C:\Users\[username]\AppData\Local\Autodesk\3dsMax\2018 - 64bit\ENU\scripts\startup
-- It saves the scene data for csMergeBy in the .max file using CustomFileStream which is added in 3dsMax 2019.
-------------------------------------------------------------------------------
global csMergeByRol
macroScript csMergeBy
	category:"csTool"
	toolTip:"csMergeBy"
(
	dotNet.loadAssembly "system.xml"
	local rolWidth = 600
	local rolHeight = 644
	local dotnetColor = dotnetclass "system.drawing.color"
	local maxBgCol = (colorman.getcolor #background * 255) as color
	local dotnetBGCol = dotnetColor.fromArgb maxBgCol.r maxBgCol.g maxBgCol.b
	local maxFgCol = (colorman.getcolor #text * 255) as color
	local dotnetFGCol = dotnetColor.fromArgb maxFgCol.r maxFgCol.g maxFgCol.b
	local selectMaxFileBtnText = "Select .max file to merge from"
	try (destroyDialog csMergeByRol)catch()
	rollout csMergeByRol "csMergeBy 1.0" (
		button selectMaxFileBtn selectMaxFileBtnText width:(rolWidth - 24) offset:[-2,0]
		label mergeByLbl "Merge by" align:#left 
		dropdownlist typedrplst "" items:#("Layer - with hierarchy", "Layer - no hierarchy", "SelectionSet", "ObjectID", "MaterialName") pos:(mergeByLbl.pos + [48,-2]) width:(rolWidth/2 - 48 - 10)
		checkbox prvNamesChkbk "Preview object names" pos:(typedrplst.pos + [250, 0]) checked:true
		dotNetControl tv "TreeView" width:(rolWidth/2 - 10) height:(rolHeight - 119) align:#left across:2
		multilistbox objNamesMlbx "" width:(rolWidth/2 - 24) height:40 align:#right
		button mergeBtn "Merge" width:(rolWidth - 24) height:36 align:#center
		hyperLink creditHplnk "(c)Changsoo Eun - www.changsooeun.com" color:maxFgCol hoverColor:maxFgCol visitedColor:maxFgCol address:"http://www.changsooeun.com" align:#center
		
		local sceneXmlDoc = undefined
		local objNamesOfSelected = #()
		-- UI FUNCITONS
		fn qsortStricmp a1 a2 = stricmp a1 a2
		fn initTV tv = (
			tv.Indent= 12
			tv.CheckBoxes = false 
			tv.HideSelection = true
			tv.BackColor= dotnetBGCol
			tv.ForeColor = dotnetFGCol
		)
		fn xml2tv argXmlNode argTreeviewNode  = (
			tv.beginUPdate()
			local objNames = #()			
			for i = 0 to (argXmlNode.childnodes.count - 1) do (
				local childXmlNode = argXmlNode.childnodes.Itemof[i]
				local nodename = (childXmlNode.attributes.ItemOf["n"]).value				
				if childXmlNode.name != "o" then (			
					local childTreeviewNode = (dotNetObject "System.Windows.Forms.TreeNode" nodename)
					argTreeviewNode.nodes.add childTreeviewNode
					xml2tv childXmlNode childTreeviewNode
				)
				else(
					append objNames nodename
				)
			)
			argTreeviewNode.tag = (dotnetMxsvalue objNames)
			tv.EndUpdate()	
		)
		fn collectAttrNames argXmlDoc argName elemName:"o" valueType:undefined = (
			local result = #()
			local xmlElems = argXmlDoc.selectNodes ("//" + elemName)
			for i = 1 to xmlElems.count do (
				local anElem = xmlElems.ItemOf[(i - 1)]
				appendifunique result anElem.Attributes.itemOf[argName].value
			)
			if valueType != undefined then (
				if valueType == #integer then (
					result = (for itm in result collect (itm as integer))
					sort result
				)
			)
			else (
				qsort result qsortStricmp
			)
			result
		)	
		fn buildFlatTV argArr argXmlDoc argAttrName = (
			tv.beginUPdate()
			for itm in argArr do (
				local childTreeviewNode = (dotNetObject "System.Windows.Forms.TreeNode" (itm as string))
				tv.nodes.add childTreeviewNode
				if argAttrName == "n" then (
					local aLayerXmlElem = argXmlDoc.selectSingleNode ("//layer[@n='" + itm + "']")
					local objNames = #()
					if aLayerXmlElem.childnodes.count > 0 then (
						for i = 0 to (aLayerXmlElem.childnodes.count - 1) do (
							local childXmlNode = aLayerXmlElem.childnodes.Itemof[i]
							if childXmlNode.name == "o" then (			
								append objNames (childXmlNode.attributes.ItemOf["n"]).value				
							)
						)
					)
					childTreeviewNode.tag = (dotnetMxsvalue objNames)
				)
				if argAttrName == "id" or argAttrName == "mtl" then (
					local xmlElems = argXmlDoc.selectNodes ("//o[@" + argAttrName + "='" + (itm as string) + "']")
					childTreeviewNode.tag = (dotnetMxsvalue (for i = 1 to xmlElems.count collect xmlElems.ItemOf[(i - 1)].Attributes.itemOf["n"].value))
				)
				if argAttrName == "ssn" then (					
					local aSSxmlElem = argXmlDoc.selectSingleNode ("//ss[@ssn='" + itm + "']")
					local objhndls = aSSxmlElem.Attributes.ItemOf["objhndls"].value
					local objNames = #()
					for hndl in ((execute objhndls) as array) do (
						append objNames (argXmlDoc.selectSingleNode ("//o[@hndl='" + (hndl as string) + "']")).Attributes.ItemOF["n"].value
					)
					childTreeviewNode.tag = (dotnetMxsvalue objNames)
				)
			)
			tv.EndUpdate()
		)
		fn fillTV tv type:"Layer - with hierarchy" msg:false = ( -- #layerhierarchy
			tv.Nodes.Clear()
			if sceneXmlDoc != undefined then (
				local st = timestamp()						
				local rootElem = sceneXmlDoc.documentElement		
				if rootElem != undefined then (
					if type == typedrplst.items[1] then (
						local hierarchyElem = rootElem.Item["Hierarchy"]						
						xml2tv hierarchyElem tv
					)
					if type == typedrplst.items[2] then (
						local items = (collectAttrNames sceneXmlDoc "n" elemName:"layer")
						if items.count > 0 then (
							buildFlatTV items sceneXmlDoc "n"
						)
					)	
					if type == typedrplst.items[3] then (
						local items = (collectAttrNames sceneXmlDoc "ssn" elemName:"ss")
						if items.count > 0 then (
							buildFlatTV items sceneXmlDoc "ssn"
						)
					)		
					if type == typedrplst.items[4] then (
						local items = (collectAttrNames sceneXmlDoc "id" valueType:#integer) 
						if items.count > 0 then (
							buildFlatTV items sceneXmlDoc "id"
						)
					)
					if type == typedrplst.items[5] then (
						local items = (collectAttrNames sceneXmlDoc "mtl")
						if items.count > 0 then (
							buildFlatTV items sceneXmlDoc "mtl"
						)
					)					
				)
				if msg == true then (format "%s\n" (((timestamp()) - st)/1000.0))
			)
		)
		fn updateTV = (
			if sceneXmlDoc != undefined then (
				fillTV tv type:typedrplst.selected msg:false
				tv.expandAll()			
			)
			else(
				tv.Nodes.Clear()
				objNamesMlbx.items = #()
			)
		)
		fn getChildrenTVnode TVNd tvNodeChildren:#() = (
			for i = 0 to (TvNd.Nodes.count - 1) do (
				local aKid = TvNd.Nodes.Item[i]
				append tvNodeChildren aKid
				getChildrenTVnode aKid tvNodeChildren:tvNodeChildren
			)
			tvNodeChildren
		)		

		local selectedFontFamily = dotNetObject "system.drawing.fontfamily" "tahoma" --this makes the font object  
		local selectedFontStyle = dotNetClass "system.drawing.fontStyle"				
		local selectedFont = dotNetObject "system.drawing.font" selectedFontFamily 8 selectedFontStyle.bold  
		local defaultFont = dotNetObject "system.drawing.font" selectedFontFamily 8 selectedFontStyle.Regular  		
		-- UI EVENTS
		fn setAsDefaultNode argNode = (
			argNode.BackColor = dotnetBGCol
			argNode.ForeColor = dotnetFGCol
			argNode.nodeFont = defaultFont							
			argNode.name = ""			
		) 
		fn setAsSelectedNode argNode = (
			argNode.BackColor = dotnetColor.dodgerblue
			argNode.ForeColor = dotnetColor.yellow
			argNode.nodeFont = selectedFont		
			argNode.name = "selected"			
		) 		
		fn updateObjList = (
			objname2show = #()			
			local allSelNodes = (tv.nodes.find "selected" True)
			for sn in allSelNodes do (
				join objname2show sn.tag.value
			)			
			qsort objname2show qsortStricmp
			if prvNamesChkbk.checked == true then (
				objNamesMlbx.items = objname2show
			)
			objNamesOfSelected = objname2show
			objNamesMlbx.selection = ((for i = 1 to objNamesMlbx.items.count collect i) as bitarray)				
		)		
		on tv BeforeSelect arg do (
			tv.beginUpdate()
			if tv.SelectedNode != undefined then (
				if keyboard.controlPressed == false then (
					setAsDefaultNode tv.SelectedNode
				)
				else(
					setAsSelectedNode tv.SelectedNode
				)
			)
			if keyboard.controlPressed == false then (
				local allSelNodes = (tv.nodes.find "selected" True)
				for sn in allSelNodes do (
					setAsDefaultNode sn
				)
			)
			if arg.Node.name == "selected" then (
				setAsDefaultNode arg.Node				
			)
			else (
				setAsSelectedNode arg.Node						
			)
			tv.endUpdate()
		)
		on tv AfterSelect arg do (
			tv.beginUpdate()
			updateObjList()
			tv.selectedNode = undefined
			tv.endUpdate()
		)
		local rightClickedNode = undefined
		on tv MouseDown arg do (
			rightClickedNode = tv.GetNodeAt (dotNetObject "System.Drawing.Point" arg.x arg.y)
			if rightClickedNode != undefined then (
				if rightClickedNode.name == "selected" then (
					setAsSelectedNode rightClickedNode		
				)
				else (
					setAsDefaultNode rightClickedNode						
				)			
			)
		)
		on tv MouseUp arg do ( -- RIGHTCLICK
			if arg.button == arg.button.Right then (
				rcMenu rightclickMenu (
					menuItem selectChildren "Select all children"
					menuItem SelectAll "Select all"
					menuItem SelectNone "Select none"
					menuItem invertSelection "Invert selection"

					on selectChildren picked do (
						local allSelNodes = (csMergeByRol.tv.nodes.find "selected" True)
						if keyboard.controlPressed == false then (
							for sn in allSelNodes do (
								setAsDefaultNode sn
							)
						)
						setAsSelectedNode	rightClickedNode								
						local selectedChildren = getChildrenTVnode rightClickedNode tvNodeChildren:#()
						for sc in selectedChildren do (
							setAsSelectedNode sc
						)	
						updateObjList()
					)
					on SelectAll picked do (
						for nd in  (csMergeByRol.tv.nodes.find "" True) do (
							setAsSelectedNode nd
						)
						updateObjList()
					)
					on SelectNone picked do (
						for nd in  (tv.nodes.find "selected" True) do (
							setAsDefaultNode nd
						)
						updateObjList()
					)
					on invertSelection picked do (
						local nonselectedNodes = for nd in (tv.nodes.find "" True) collect nd
						local selectedNodes = for nd in (tv.nodes.find "selected" True) collect nd						
						for nd in  nonselectedNodes do ( setAsSelectedNode nd )							
						for nd in  selectedNodes do ( setAsDefaultNode nd )						
						updateObjList()
					)					
				) 
				popUpMenu rightclickMenu pos:mouse.screenpos --rollout:csMergeByRol align:#align_topleft				
			)
		)
		on selectMaxFileBtn pressed do (
			local selectedMaxFile = (getOpenFileName caption:"Select .max file to merge from" filename:(maxfilepath + maxfilename) types:"3dsMax files(*.max)|*.max" historyCategory:"csMergeBy")
			if selectedMaxFile != undefined then (
				objNamesMlbx.items = #()
				tv.Nodes.Clear()
				local isSceneDataThere = try(CustomFileStream.isCustomFileStreamOperable selectedMaxFile "csMergeBySceneData")catch(undefined)
				if isSceneDataThere == true then (				
					selectMaxFileBtn.text = selectedMaxFile
					local sceneDataXml = (CustomFileStream.readStream selectedMaxFile "csMergeBySceneData")
					sceneXmlDoc = dotNetObject "system.xml.xmlDocument"				
					sceneXmlDoc.LoadXml sceneDataXml
					updateTV()					
				)
				else(
					selectMaxFileBtn.text = selectMaxFileBtnText
					sceneXmlDoc = undefined
					updateTV()
					messagebox "csMergeBySceneData doesn exist in the scene"					
				)
			)
		)
		on prvNamesChkbk changed arg do (
			if arg == false then (
				objNamesMlbx.items = #()
			)
			else(
				updateObjList()
			)
		)
		on typedrplst selected arg do (
			updateTV()
			objNamesMlbx.items = #()
		)
		on mergeBtn pressed do (
			local onames2merge = #()
			if prvNamesChkbk.checked == true then (
				onames2merge = for i in (objNamesMlbx.selection as array) collect objNamesMlbx.items[i]
			)
			else(
				onames2merge = objNamesOfSelected
			)
			if onames2merge.count > 0 then (
				format "-- Merging % objects\n" onames2merge.count
				mergeMAXFile selectMaxFileBtn.text onames2merge
				local mergedObjs = (getLastMergedNodes())
				selectionSets["JustMerged"] = mergedObjs
				messagebox ((mergedObjs.count as string) + " objects are merged") title:"csMergeBy"
			)
		)
		on csMergeByRol open do (
			sceneXmlDoc = undefined
			initTV tv
		)
	)
	createDialog csMergeByRol rolWidth rolHeight
)

	
