-------------------------------------------------------------------------------
-- csMergeBySave
-- by Changsoo Eun
-- www.changsooeun.com
-- 
-- Put this file into startup folder or one of plugins folder
-- C:\Users\[username]\AppData\Local\Autodesk\3dsMax\2018 - 64bit\ENU\scripts\startup
-- It saves the scene data for csMergeBy in the .max file using CustomFileStream which is added in 3dsMax 2019.
-------------------------------------------------------------------------------
(
-- 	clearListener()
	global recurseLayerHierarchy
	fn recurseLayerHierarchy argLayer argElem = (
		fn getObjFromLayer argLayer = (
			local result = #()
			local nodes = #()
			argLayer.nodes &nodes
			result = for n in nodes collect n
			result
		)				
		local xmlDOc = argElem.OwnerDocument
		local numChildren = 0
		local rootLayers = #()
		if argLayer == undefined then (
			for i = 1 to layerManager.count do (
				local l = layerManager.getLayer (i - 1)
				if (l.getParent()) == undefined then (
					append rootLayers l
				)	
			)
			numChildren = rootLayers.count
		)
		else(
			numChildren = (argLayer.getNumChildren()) 
		)
		if numChildren > 0 then (
			for i = 1 to numChildren do (
				local newElement = xmlDoc.createElement "layer"
				local aKid = undefined 
				if argLayer == undefined then (
					aKid = rootLayers[i]
				)
				else (
					aKid = (argLayer.getChild i)
				)
				if aKid != undefined then (
					newElement.setAttribute "n" aKid.name
					argElem.appendChild newElement
					for o in (getObjFromLayer aKid) do (
						local oElem = xmlDoc.createElement "o"
						oElem.setAttribute "n" o.name
						oElem.setAttribute "id" (o.gbufferchannel as string)
						oElem.setAttribute "hndl" (o.inode.handle as string)
						local mtlname = "undefined"
						if o.material != undefined then mtlname = (o.material.name as string)	
						oElem.setAttribute "mtl" mtlname	
						newElement.appendChild oElem
					)		
					recurseLayerHierarchy aKid newElement
				)
			)
		)
	)
	global saveData4MergeBy
	fn saveData4MergeBy argMaxFile = (
		dotNet.loadAssembly "system.xml"
		local st = timestamp()
		local sceneXmlDoc = dotNetObject "system.xml.xmlDocument"
		local rootElem = sceneXmlDoc.createElement "Scene"
		sceneXmlDoc.appendChild rootElem	
		local hierarchyElem = sceneXmlDoc.createElement "Hierarchy"
		rootElem.appendChild hierarchyElem			
		recurseLayerHierarchy undefined hierarchyElem
		
		local selectionSetsElem = sceneXmlDoc.createElement "SelectionSets"
		rootElem.appendChild selectionSetsElem		
		for ss in selectionSets do (
			local ssElem = sceneXmlDoc.createElement "ss"
			selectionSetsElem.appendChild ssElem
			ssElem.setAttribute "ssn" (substituteString (substituteString (ss.name) "'" "") "\"" "") 
			ssElem.setAttribute "objhndls" (((for o in ss collect o.inode.handle) as bitarray) as string)
		)
-- 		format "-- saved merge data in %s\n" (((timestamp()) - st)/1000.0)
		CustomFileStream.writeStream argMaxFile "csMergeBySceneData" sceneXmlDoc.OuterXml persistent:false noLoadOnSceneLoad:false append:false
-- 		sceneXmlDoc.save @"c:\temp\csMergeBy.xml"
	)
	callbacks.removeScripts id:#saveData4MergeBy
	callbacks.addScript #filePostSave "saveData4MergeBy (callbacks.notificationParam())" id:#saveData4MergeBy
)